"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    description: str = None,
    resource_query: Dict = None,
    tags: Dict = None,
    configuration: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a resource group with the specified name and description. You can optionally include a resource query, or a service configuration. For more information about constructing a resource query, see Create a tag-based group in Resource Groups. For more information about service configurations, see Service configurations for resource groups.  Minimum permissions  To run this command, you must have the following permissions:    resource-groups:CreateGroup

    Args:
        name(str): The name of the group, which is the identifier of the group in other operations. You can't change the name of a resource group after you create it. A resource group name can consist of letters, numbers, hyphens, periods, and underscores. The name cannot start with AWS or aws; these are reserved. A resource group name must be unique within each AWS Region in your AWS account.
        description(str, optional): The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores, periods, and spaces. Defaults to None.
        resource_query(Dict, optional): The resource query that determines which AWS resources are members of this group. For more information about resource queries, see Create a tag-based group in Resource Groups.   A resource group can contain either a ResourceQuery or a Configuration, but not both. . Defaults to None.
        tags(Dict, optional): The tags to add to the group. A tag is key-value pair string. Defaults to None.
        configuration(List, optional): A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. A configuration is an array of GroupConfigurationItem elements. For details about the syntax of service configurations, see Service configurations for resource groups.  A resource group can contain either a Configuration or a ResourceQuery, but not both. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.group.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.group.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="create_group",
        op_kwargs={
            "Name": name,
            "Description": description,
            "ResourceQuery": resource_query,
            "Tags": tags,
            "Configuration": configuration,
        },
    )


async def delete(hub, ctx, group_name: str = None, group: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified resource group. Deleting a resource group does not delete any resources that are members of the group; it only deletes the group structure.  Minimum permissions  To run this command, you must have the following permissions:    resource-groups:DeleteGroup

    Args:
        group_name(str, optional): Deprecated - don't use this parameter. Use Group instead. Defaults to None.
        group(str, optional): The name or the ARN of the resource group to delete. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.group.init.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.group.init.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="delete_group",
        op_kwargs={"GroupName": group_name, "Group": group},
    )


async def get(hub, ctx, group_name: str = None, group: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specified resource group.  Minimum permissions  To run this command, you must have the following permissions:    resource-groups:GetGroup

    Args:
        group_name(str, optional): Deprecated - don't use this parameter. Use Group instead. Defaults to None.
        group(str, optional): The name or the ARN of the resource group to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.group.init.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.group.init.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="get_group",
        op_kwargs={"GroupName": group_name, "Group": group},
    )


async def list_all(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of existing resource groups in your account.  Minimum permissions  To run this command, you must have the following permissions:    resource-groups:ListGroups

    Args:
        filters(List, optional): Filters, formatted as GroupFilter objects, that you want to apply to a ListGroups operation.    resource-type - Filter the results to include only those of the specified resource types. Specify up to five resource types in the format AWS::ServiceCode::ResourceType . For example, AWS::EC2::Instance, or AWS::S3::Bucket.    configuration-type - Filter the results to include only those groups that have the specified configuration types attached. The current supported values are:    AWS:EC2::CapacityReservationPool     AWS:EC2::HostManagement     . Defaults to None.
        max_results(int, optional): The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the NextToken response element is present and has a value (is not null). Include that value as the NextToken request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check NextToken after every operation to ensure that you receive all of the results. Defaults to None.
        next_token(str, optional): The parameter for receiving additional results if you receive a NextToken response in a previous request. A NextToken response indicates that more output is available. Set this parameter to the value provided by a previous call's NextToken response to indicate where the output should continue from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.group.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.group.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="list_groups",
        op_kwargs={
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub, ctx, group_name: str = None, group: str = None, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the description for an existing group. You cannot update the name of a resource group.  Minimum permissions  To run this command, you must have the following permissions:    resource-groups:UpdateGroup

    Args:
        group_name(str, optional): Don't use this parameter. Use Group instead. Defaults to None.
        group(str, optional): The name or the ARN of the resource group to modify. Defaults to None.
        description(str, optional): The new description that you want to update the resource group with. Descriptions can contain letters, numbers, hyphens, underscores, periods, and spaces. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.group.init.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.group.init.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="update_group",
        op_kwargs={"GroupName": group_name, "Group": group, "Description": description},
    )
