"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, group: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the service configuration associated with the specified resource group. For details about the service configuration syntax, see Service configurations for resource groups.  Minimum permissions  To run this command, you must have the following permissions:    resource-groups:GetGroupConfiguration

    Args:
        group(str, optional): The name or the ARN of the resource group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.group.configuration.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.group.configuration.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="get_group_configuration",
        op_kwargs={"Group": group},
    )


async def put(hub, ctx, group: str = None, configuration: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Attaches a service configuration to the specified group. This occurs asynchronously, and can take time to complete. You can use GetGroupConfiguration to check the status of the update.  Minimum permissions  To run this command, you must have the following permissions:    resource-groups:PutGroupConfiguration

    Args:
        group(str, optional): The name or ARN of the resource group with the configuration that you want to update. Defaults to None.
        configuration(List, optional): The new configuration to associate with the specified group. A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. A configuration is an array of GroupConfigurationItem elements. For information about the syntax of a service configuration, see Service configurations for resource groups.  A resource group can contain either a Configuration or a ResourceQuery, but not both. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.resource_group.group.configuration.put(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.resource_group.group.configuration.put
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="resource-groups",
        operation="put_group_configuration",
        op_kwargs={"Group": group, "Configuration": configuration},
    )
