"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    input_: Dict,
    output: Dict,
    name: str,
    settings: Dict,
    role_arn: str,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Rekognition stream processor that you can use to detect and recognize faces in a streaming video. Amazon Rekognition Video is a consumer of live video from Amazon Kinesis Video Streams. Amazon Rekognition Video sends analysis results to Amazon Kinesis Data Streams. You provide as input a Kinesis video stream (Input) and a Kinesis data stream (Output) stream. You also specify the face recognition criteria in Settings. For example, the collection containing faces that you want to recognize. Use Name to assign an identifier for the stream processor. You use Name to manage the stream processor. For example, you can start processing the source video by calling StartStreamProcessor with the Name field.  After you have finished analyzing a streaming video, use StopStreamProcessor to stop processing. You can delete the stream processor by calling DeleteStreamProcessor. This operation requires permissions to perform the rekognition:CreateStreamProcessor action. If you want to tag your stream processor, you also require permission to perform the rekognition:TagResource operation.

    Args:
        input_(Dict): Kinesis video stream stream that provides the source streaming video. If you are using the AWS CLI, the parameter name is StreamProcessorInput.
        output(Dict): Kinesis data stream stream to which Amazon Rekognition Video puts the analysis results. If you are using the AWS CLI, the parameter name is StreamProcessorOutput.
        name(str): An identifier you assign to the stream processor. You can use Name to manage the stream processor. For example, you can get the current status of the stream processor by calling DescribeStreamProcessor. Name is idempotent. .
        settings(Dict): Face recognition input parameters to be used by the stream processor. Includes the collection to use for face recognition and the face attributes to detect.
        role_arn(str): ARN of the IAM role that allows access to the stream processor.
        tags(Dict, optional):  A set of tags (key-value pairs) that you want to attach to the stream processor. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.stream_processor.create(
                ctx, input_=value, output=value, name=value, settings=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.stream_processor.create input_=value, output=value, name=value, settings=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="create_stream_processor",
        op_kwargs={
            "Input": input_,
            "Output": output,
            "Name": name,
            "Settings": settings,
            "RoleArn": role_arn,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the stream processor identified by Name. You assign the value for Name when you create the stream processor with CreateStreamProcessor. You might not be able to use the same name for a stream processor for a few seconds after calling DeleteStreamProcessor.

    Args:
        name(str): The name of the stream processor you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.stream_processor.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.stream_processor.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="delete_stream_processor",
        op_kwargs={"Name": name},
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about a stream processor created by CreateStreamProcessor. You can get information about the input and output streams, the input parameters for the face recognition being performed, and the current status of the stream processor.

    Args:
        name(str): Name of the stream processor for which you want information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.stream_processor.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.stream_processor.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="describe_stream_processor",
        op_kwargs={"Name": name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of stream processors that you have created with CreateStreamProcessor.

    Args:
        next_token(str, optional): If the previous response was incomplete (because there are more stream processors to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of stream processors. . Defaults to None.
        max_results(int, optional): Maximum number of stream processors you want Amazon Rekognition Video to return in the response. The default is 1000. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.stream_processor.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.stream_processor.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="list_stream_processors",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def start(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts processing a stream processor. You create a stream processor by calling CreateStreamProcessor. To tell StartStreamProcessor which stream processor to start, use the value of the Name field specified in the call to CreateStreamProcessor.

    Args:
        name(str): The name of the stream processor to start processing.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.stream_processor.start(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.stream_processor.start name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="start_stream_processor",
        op_kwargs={"Name": name},
    )


async def stop(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a running stream processor that was created by CreateStreamProcessor.

    Args:
        name(str): The name of a stream processor created by CreateStreamProcessor.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.stream_processor.stop(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.stream_processor.stop name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="stop_stream_processor",
        op_kwargs={"Name": name},
    )
