"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    project_arn: str,
    version_name: str,
    output_config: Dict,
    training_data: Dict,
    testing_data: Dict,
    tags: Dict = None,
    kms_key_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new version of a model and begins training. Models are managed as part of an Amazon Rekognition Custom Labels project. You can specify one training dataset and one testing dataset. The response from CreateProjectVersion is an Amazon Resource Name (ARN) for the version of the model.  Training takes a while to complete. You can get the current status by calling DescribeProjectVersions. Once training has successfully completed, call DescribeProjectVersions to get the training results and evaluate the model.  After evaluating the model, you start the model by calling StartProjectVersion. This operation requires permissions to perform the rekognition:CreateProjectVersion action.

    Args:
        project_arn(str): The ARN of the Amazon Rekognition Custom Labels project that manages the model that you want to train.
        version_name(str): A name for the version of the model. This value must be unique.
        output_config(Dict): The Amazon S3 location to store the results of training.
        training_data(Dict): The dataset to use for training. .
        testing_data(Dict): The dataset to use for testing.
        tags(Dict, optional):  A set of tags (key-value pairs) that you want to attach to the model. . Defaults to None.
        kms_key_id(str, optional): The identifier for your AWS Key Management Service (AWS KMS) customer master key (CMK). You can supply the Amazon Resource Name (ARN) of your CMK, the ID of your CMK, or an alias for your CMK. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. The key is also used to encrypt training results and manifest files written to the output Amazon S3 bucket (OutputConfig). If you don't specify a value for KmsKeyId, images copied into the service are encrypted using a key that AWS owns and manages. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.project.version.create(
                ctx,
                project_arn=value,
                version_name=value,
                output_config=value,
                training_data=value,
                testing_data=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.project.version.create project_arn=value, version_name=value, output_config=value, training_data=value, testing_data=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="create_project_version",
        op_kwargs={
            "ProjectArn": project_arn,
            "VersionName": version_name,
            "OutputConfig": output_config,
            "TrainingData": training_data,
            "TestingData": testing_data,
            "Tags": tags,
            "KmsKeyId": kms_key_id,
        },
    )


async def delete(hub, ctx, project_version_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon Rekognition Custom Labels model.  You can't delete a model if it is running or if it is training. To check the status of a model, use the Status field returned from DescribeProjectVersions. To stop a running model call StopProjectVersion. If the model is training, wait until it finishes. This operation requires permissions to perform the rekognition:DeleteProjectVersion action.

    Args:
        project_version_arn(str): The Amazon Resource Name (ARN) of the model version that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.project.version.delete(
                ctx, project_version_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.project.version.delete project_version_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="delete_project_version",
        op_kwargs={"ProjectVersionArn": project_version_arn},
    )


async def describe_all(
    hub,
    ctx,
    project_arn: str,
    version_names: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists and describes the models in an Amazon Rekognition Custom Labels project. You can specify up to 10 model versions in ProjectVersionArns. If you don't specify a value, descriptions for all models are returned. This operation requires permissions to perform the rekognition:DescribeProjectVersions action.

    Args:
        project_arn(str): The Amazon Resource Name (ARN) of the project that contains the models you want to describe.
        version_names(List, optional): A list of model version names that you want to describe. You can add up to 10 model version names to the list. If you don't specify a value, all model descriptions are returned. A version name is part of a model (ProjectVersion) ARN. For example, my-model.2020-01-21T09.10.15 is the version name in the following ARN. arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/my-model.2020-01-21T09.10.15/1234567890123. Defaults to None.
        next_token(str, optional): If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. . Defaults to None.
        max_results(int, optional): The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.project.version.describe_all(ctx, project_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.project.version.describe_all project_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="describe_project_versions",
        op_kwargs={
            "ProjectArn": project_arn,
            "VersionNames": version_names,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def start(hub, ctx, project_version_arn: str, min_inference_units: int) -> Dict:
    r"""
    **Autogenerated function**

    Starts the running of the version of a model. Starting a model takes a while to complete. To check the current state of the model, use DescribeProjectVersions. Once the model is running, you can detect custom labels in new images by calling DetectCustomLabels.  You are charged for the amount of time that the model is running. To stop a running model, call StopProjectVersion.  This operation requires permissions to perform the rekognition:StartProjectVersion action.

    Args:
        project_version_arn(str): The Amazon Resource Name(ARN) of the model version that you want to start.
        min_inference_units(int): The minimum number of inference units to use. A single inference unit represents 1 hour of processing and can support up to 5 Transaction Pers Second (TPS). Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.project.version.start(
                ctx, project_version_arn=value, min_inference_units=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.project.version.start project_version_arn=value, min_inference_units=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="start_project_version",
        op_kwargs={
            "ProjectVersionArn": project_version_arn,
            "MinInferenceUnits": min_inference_units,
        },
    )


async def stop(hub, ctx, project_version_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a running model. The operation might take a while to complete. To check the current status, call DescribeProjectVersions.

    Args:
        project_version_arn(str): The Amazon Resource Name (ARN) of the model version that you want to delete. This operation requires permissions to perform the rekognition:StopProjectVersion action.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.project.version.stop(ctx, project_version_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.project.version.stop project_version_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="stop_project_version",
        op_kwargs={"ProjectVersionArn": project_version_arn},
    )
