"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, project_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon Rekognition Custom Labels project. A project is a logical grouping of resources (images, Labels, models) and operations (training, evaluation and detection).  This operation requires permissions to perform the rekognition:CreateProject action.

    Args:
        project_name(str): The name of the project to create.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.project.init.create(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.project.init.create project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="create_project",
        op_kwargs={"ProjectName": project_name},
    )


async def delete(hub, ctx, project_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Amazon Rekognition Custom Labels project. To delete a project you must first delete all models associated with the project. To delete a model, see DeleteProjectVersion. This operation requires permissions to perform the rekognition:DeleteProject action.

    Args:
        project_arn(str): The Amazon Resource Name (ARN) of the project that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.project.init.delete(ctx, project_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.project.init.delete project_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="delete_project",
        op_kwargs={"ProjectArn": project_arn},
    )


async def describe_all(
    hub, ctx, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists and gets information about your Amazon Rekognition Custom Labels projects. This operation requires permissions to perform the rekognition:DescribeProjects action.

    Args:
        next_token(str, optional): If the previous response was incomplete (because there is more results to retrieve), Amazon Rekognition Custom Labels returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. . Defaults to None.
        max_results(int, optional): The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.project.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.project.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="describe_projects",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
