"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    job_id: str,
    max_results: int = None,
    next_token: str = None,
    sort_by: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the path tracking results of a Amazon Rekognition Video analysis started by StartPersonTracking. The person path tracking operation is started by a call to StartPersonTracking which returns a job identifier (JobId). When the operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to StartPersonTracking. To get the results of the person path tracking operation, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so, call GetPersonTracking and pass the job identifier (JobId) from the initial call to StartPersonTracking.  GetPersonTracking returns an array, Persons, of tracked persons and the time(s) their paths were tracked in the video.    GetPersonTracking only returns the default facial attributes (BoundingBox, Confidence, Landmarks, Pose, and Quality). The other facial attributes listed in the Face object of the following response syntax are not returned.  For more information, see FaceDetail in the Amazon Rekognition Developer Guide.  By default, the array is sorted by the time(s) a person's path is tracked in the video. You can sort by tracked persons by specifying INDEX for the SortBy input parameter. Use the MaxResults parameter to limit the number of items returned. If there are more results than specified in MaxResults, the value of NextToken in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call GetPersonTracking and populate the NextToken request parameter with the token value returned from the previous call to GetPersonTracking.

    Args:
        job_id(str): The identifier for a job that tracks persons in a video. You get the JobId from a call to StartPersonTracking. .
        max_results(int, optional): Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000. Defaults to None.
        next_token(str, optional): If the previous response was incomplete (because there are more persons to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of persons. . Defaults to None.
        sort_by(str, optional): Sort to use for elements in the Persons array. Use TIMESTAMP to sort array elements by the time persons are detected. Use INDEX to sort by the tracked persons. If you sort by INDEX, the array elements for each person are sorted by detection confidence. The default sort is by TIMESTAMP. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.person_tracking.get(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.person_tracking.get job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="get_person_tracking",
        op_kwargs={
            "JobId": job_id,
            "MaxResults": max_results,
            "NextToken": next_token,
            "SortBy": sort_by,
        },
    )


async def start(
    hub,
    ctx,
    video: Dict,
    client_request_token: str = None,
    notification_channel: Dict = None,
    job_tag: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts the asynchronous tracking of a person's path in a stored video. Amazon Rekognition Video can track the path of people in a video stored in an Amazon S3 bucket. Use Video to specify the bucket name and the filename of the video. StartPersonTracking returns a job identifier (JobId) which you use to get the results of the operation. When label detection is finished, Amazon Rekognition publishes a completion status to the Amazon Simple Notification Service topic that you specify in NotificationChannel.  To get the results of the person detection operation, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so, call GetPersonTracking and pass the job identifier (JobId) from the initial call to StartPersonTracking.

    Args:
        video(Dict): The video in which you want to detect people. The video must be stored in an Amazon S3 bucket.
        client_request_token(str, optional): Idempotent token used to identify the start request. If you use the same token with multiple StartPersonTracking requests, the same JobId is returned. Use ClientRequestToken to prevent the same job from being accidently started more than once. . Defaults to None.
        notification_channel(Dict, optional): The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the people detection operation to. Defaults to None.
        job_tag(str, optional): An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use JobTag to group related jobs and identify them in the completion notification. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.person_tracking.start(ctx, video=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.person_tracking.start video=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="start_person_tracking",
        op_kwargs={
            "Video": video,
            "ClientRequestToken": client_request_token,
            "NotificationChannel": notification_channel,
            "JobTag": job_tag,
        },
    )
