"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def detect(
    hub, ctx, image: Dict, min_confidence: float = None, human_loop_config: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Detects unsafe content in a specified JPEG or PNG format image. Use DetectModerationLabels to moderate images depending on your requirements. For example, you might want to filter images that contain nudity, but not images containing suggestive content. To filter images, use the labels returned by DetectModerationLabels to determine which types of content are appropriate. For information about moderation labels, see Detecting Unsafe Content in the Amazon Rekognition Developer Guide. You pass the input image either as base64-encoded image bytes or as a reference to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes is not supported. The image must be either a PNG or JPEG formatted file.

    Args:
        image(Dict): The input image as base64-encoded bytes or an S3 object. If you use the AWS CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is not supported.  If you are using an AWS SDK to call Amazon Rekognition, you might not need to base64-encode image bytes passed using the Bytes field. For more information, see Images in the Amazon Rekognition developer guide.
        min_confidence(float, optional): Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels with a confidence level lower than this specified value. If you don't specify MinConfidence, the operation returns labels with confidence values greater than or equal to 50 percent. Defaults to None.
        human_loop_config(Dict, optional): Sets up the configuration for human evaluation, including the FlowDefinition the image will be sent to. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.moderation_label.detect(ctx, image=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.moderation_label.detect image=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="detect_moderation_labels",
        op_kwargs={
            "Image": image,
            "MinConfidence": min_confidence,
            "HumanLoopConfig": human_loop_config,
        },
    )
