"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    job_id: str,
    max_results: int = None,
    next_token: str = None,
    sort_by: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the face search results for Amazon Rekognition Video face search started by StartFaceSearch. The search returns faces in a collection that match the faces of persons detected in a video. It also includes the time(s) that faces are matched in the video. Face search in a video is an asynchronous operation. You start face search by calling to StartFaceSearch which returns a job identifier (JobId). When the search operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to StartFaceSearch. To get the search results, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so, call GetFaceSearch and pass the job identifier (JobId) from the initial call to StartFaceSearch. For more information, see Searching Faces in a Collection in the Amazon Rekognition Developer Guide. The search results are retured in an array, Persons, of PersonMatch objects. EachPersonMatch element contains details about the matching faces in the input collection, person information (facial attributes, bounding boxes, and person identifer) for the matched person, and the time the person was matched in the video.   GetFaceSearch only returns the default facial attributes (BoundingBox, Confidence, Landmarks, Pose, and Quality). The other facial attributes listed in the Face object of the following response syntax are not returned. For more information, see FaceDetail in the Amazon Rekognition Developer Guide.   By default, the Persons array is sorted by the time, in milliseconds from the start of the video, persons are matched. You can also sort by persons by specifying INDEX for the SORTBY input parameter.

    Args:
        job_id(str): The job identifer for the search request. You get the job identifier from an initial call to StartFaceSearch.
        max_results(int, optional): Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000. Defaults to None.
        next_token(str, optional): If the previous response was incomplete (because there is more search results to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of search results. . Defaults to None.
        sort_by(str, optional): Sort to use for grouping faces in the response. Use TIMESTAMP to group faces by the time that they are recognized. Use INDEX to sort by recognized faces. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.face.search.get(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.face.search.get job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="get_face_search",
        op_kwargs={
            "JobId": job_id,
            "MaxResults": max_results,
            "NextToken": next_token,
            "SortBy": sort_by,
        },
    )


async def start(
    hub,
    ctx,
    video: Dict,
    collection_id: str,
    client_request_token: str = None,
    face_match_threshold: float = None,
    notification_channel: Dict = None,
    job_tag: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts the asynchronous search for faces in a collection that match the faces of persons detected in a stored video. The video must be stored in an Amazon S3 bucket. Use Video to specify the bucket name and the filename of the video. StartFaceSearch returns a job identifier (JobId) which you use to get the search results once the search has completed. When searching is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in NotificationChannel. To get the search results, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so, call GetFaceSearch and pass the job identifier (JobId) from the initial call to StartFaceSearch. For more information, see procedure-person-search-videos.

    Args:
        video(Dict): The video you want to search. The video must be stored in an Amazon S3 bucket. .
        client_request_token(str, optional): Idempotent token used to identify the start request. If you use the same token with multiple StartFaceSearch requests, the same JobId is returned. Use ClientRequestToken to prevent the same job from being accidently started more than once. . Defaults to None.
        face_match_threshold(float, optional): The minimum confidence in the person match to return. For example, don't return any matches where confidence in matches is less than 70%. The default value is 80%. Defaults to None.
        collection_id(str): ID of the collection that contains the faces you want to search for.
        notification_channel(Dict, optional): The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the search. . Defaults to None.
        job_tag(str, optional): An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use JobTag to group related jobs and identify them in the completion notification. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.face.search.start(
                ctx, video=value, collection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.face.search.start video=value, collection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="start_face_search",
        op_kwargs={
            "Video": video,
            "ClientRequestToken": client_request_token,
            "FaceMatchThreshold": face_match_threshold,
            "CollectionId": collection_id,
            "NotificationChannel": notification_channel,
            "JobTag": job_tag,
        },
    )
