"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, job_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets face detection results for a Amazon Rekognition Video analysis started by StartFaceDetection. Face detection with Amazon Rekognition Video is an asynchronous operation. You start face detection by calling StartFaceDetection which returns a job identifier (JobId). When the face detection operation finishes, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic registered in the initial call to StartFaceDetection. To get the results of the face detection operation, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so, call GetFaceDetection and pass the job identifier (JobId) from the initial call to StartFaceDetection.  GetFaceDetection returns an array of detected faces (Faces) sorted by the time the faces were detected.  Use MaxResults parameter to limit the number of labels returned. If there are more results than specified in MaxResults, the value of NextToken in the operation response contains a pagination token for getting the next set of results. To get the next page of results, call GetFaceDetection and populate the NextToken request parameter with the token value returned from the previous call to GetFaceDetection.

    Args:
        job_id(str): Unique identifier for the face detection job. The JobId is returned from StartFaceDetection.
        max_results(int, optional): Maximum number of results to return per paginated call. The largest value you can specify is 1000. If you specify a value greater than 1000, a maximum of 1000 results is returned. The default value is 1000. Defaults to None.
        next_token(str, optional): If the previous response was incomplete (because there are more faces to retrieve), Amazon Rekognition Video returns a pagination token in the response. You can use this pagination token to retrieve the next set of faces. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.face.detection.get(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.face.detection.get job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="get_face_detection",
        op_kwargs={"JobId": job_id, "MaxResults": max_results, "NextToken": next_token},
    )


async def start(
    hub,
    ctx,
    video: Dict,
    client_request_token: str = None,
    notification_channel: Dict = None,
    face_attributes: str = None,
    job_tag: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts asynchronous detection of faces in a stored video. Amazon Rekognition Video can detect faces in a video stored in an Amazon S3 bucket. Use Video to specify the bucket name and the filename of the video. StartFaceDetection returns a job identifier (JobId) that you use to get the results of the operation. When face detection is finished, Amazon Rekognition Video publishes a completion status to the Amazon Simple Notification Service topic that you specify in NotificationChannel. To get the results of the face detection operation, first check that the status value published to the Amazon SNS topic is SUCCEEDED. If so, call GetFaceDetection and pass the job identifier (JobId) from the initial call to StartFaceDetection. For more information, see Detecting Faces in a Stored Video in the Amazon Rekognition Developer Guide.

    Args:
        video(Dict): The video in which you want to detect faces. The video must be stored in an Amazon S3 bucket.
        client_request_token(str, optional): Idempotent token used to identify the start request. If you use the same token with multiple StartFaceDetection requests, the same JobId is returned. Use ClientRequestToken to prevent the same job from being accidently started more than once. . Defaults to None.
        notification_channel(Dict, optional): The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video to publish the completion status of the face detection operation. Defaults to None.
        face_attributes(str, optional): The face attributes you want returned.  DEFAULT - The following subset of facial attributes are returned: BoundingBox, Confidence, Pose, Quality and Landmarks.   ALL - All facial attributes are returned. Defaults to None.
        job_tag(str, optional): An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use JobTag to group related jobs and identify them in the completion notification. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.face.detection.start(ctx, video=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.face.detection.start video=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="start_face_detection",
        op_kwargs={
            "Video": video,
            "ClientRequestToken": client_request_token,
            "NotificationChannel": notification_channel,
            "FaceAttributes": face_attributes,
            "JobTag": job_tag,
        },
    )
