"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, collection_id: str, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a collection in an AWS Region. You can add faces to the collection using the IndexFaces operation.  For example, you might create collections, one for each of your application users. A user can then index faces using the IndexFaces operation and persist results in a specific collection. Then, a user can search the collection for faces in the user-specific container.  When you create a collection, it is associated with the latest version of the face model version.  Collection names are case-sensitive.  This operation requires permissions to perform the rekognition:CreateCollection action. If you want to tag your collection, you also require permission to perform the rekognition:TagResource operation.

    Args:
        collection_id(str): ID for the collection that you are creating.
        tags(Dict, optional):  A set of tags (key-value pairs) that you want to attach to the collection. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.collection.create(ctx, collection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.collection.create collection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="create_collection",
        op_kwargs={"CollectionId": collection_id, "Tags": tags},
    )


async def delete(hub, ctx, collection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified collection. Note that this operation removes all faces in the collection. For an example, see delete-collection-procedure. This operation requires permissions to perform the rekognition:DeleteCollection action.

    Args:
        collection_id(str): ID of the collection to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.collection.delete(ctx, collection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.collection.delete collection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="delete_collection",
        op_kwargs={"CollectionId": collection_id},
    )


async def describe(hub, ctx, collection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified collection. You can use DescribeCollection to get information, such as the number of faces indexed into a collection and the version of the model used by the collection for face detection. For more information, see Describing a Collection in the Amazon Rekognition Developer Guide.

    Args:
        collection_id(str): The ID of the collection to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.collection.describe(ctx, collection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.collection.describe collection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="describe_collection",
        op_kwargs={"CollectionId": collection_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns list of collection IDs in your account. If the result is truncated, the response also provides a NextToken that you can use in the subsequent request to fetch the next set of collection IDs. For an example, see Listing Collections in the Amazon Rekognition Developer Guide. This operation requires permissions to perform the rekognition:ListCollections action.

    Args:
        next_token(str, optional): Pagination token from the previous response. Defaults to None.
        max_results(int, optional): Maximum number of collection IDs to return. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rekognition.collection.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rekognition.collection.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rekognition",
        operation="list_collections",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
