"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    cluster_identifier: str,
    database: str,
    connected_database: str = None,
    db_user: str = None,
    max_results: int = None,
    next_token: str = None,
    schema: str = None,
    secret_arn: str = None,
    table: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the detailed information about a table from metadata in the cluster. The information includes its columns. A token is returned to page through the column list. Depending on the authorization method, use one of the following combinations of request parameters:    Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret.    Temporary credentials - specify the cluster identifier, the database name, and the database user name. Permission to call the redshift:GetClusterCredentials operation is required to use this method.

    Args:
        cluster_identifier(str): The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials. .
        connected_database(str, optional): A database name. The connected database is specified when you connect with your authentication credentials. . Defaults to None.
        database(str): The name of the database that contains the tables to be described. If ConnectedDatabase is not specified, this is also the database to connect to with your authentication credentials.
        db_user(str, optional): The database user name. This parameter is required when authenticating using temporary credentials. . Defaults to None.
        max_results(int, optional): The maximum number of tables to return in the response. If more tables exist than fit in one response, then NextToken is returned to page through the results. . Defaults to None.
        next_token(str, optional): A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. . Defaults to None.
        schema(str, optional): The schema that contains the table. If no schema is specified, then matching tables for all schemas are returned. . Defaults to None.
        secret_arn(str, optional): The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. . Defaults to None.
        table(str, optional): The table name. If no table is specified, then all tables for all matching schemas are returned. If no table and no schema is specified, then all tables for all schemas in the database are returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift_data.table.describe(
                ctx, cluster_identifier=value, database=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift_data.table.describe cluster_identifier=value, database=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift-data",
        operation="describe_table",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "ConnectedDatabase": connected_database,
            "Database": database,
            "DbUser": db_user,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Schema": schema,
            "SecretArn": secret_arn,
            "Table": table,
        },
    )


async def list_all(
    hub,
    ctx,
    cluster_identifier: str,
    database: str,
    connected_database: str = None,
    db_user: str = None,
    max_results: int = None,
    next_token: str = None,
    schema_pattern: str = None,
    secret_arn: str = None,
    table_pattern: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the tables in a database. If neither SchemaPattern nor TablePattern are specified, then all tables in the database are returned. A token is returned to page through the table list. Depending on the authorization method, use one of the following combinations of request parameters:    Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret.    Temporary credentials - specify the cluster identifier, the database name, and the database user name. Permission to call the redshift:GetClusterCredentials operation is required to use this method.

    Args:
        cluster_identifier(str): The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials. .
        connected_database(str, optional): A database name. The connected database is specified when you connect with your authentication credentials. . Defaults to None.
        database(str): The name of the database that contains the tables to list. If ConnectedDatabase is not specified, this is also the database to connect to with your authentication credentials.
        db_user(str, optional): The database user name. This parameter is required when authenticating using temporary credentials. . Defaults to None.
        max_results(int, optional): The maximum number of tables to return in the response. If more tables exist than fit in one response, then NextToken is returned to page through the results. . Defaults to None.
        next_token(str, optional): A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. . Defaults to None.
        schema_pattern(str, optional): A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. If SchemaPattern is not specified, then all tables that match TablePattern are returned. If neither SchemaPattern or TablePattern are specified, then all tables are returned. . Defaults to None.
        secret_arn(str, optional): The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. . Defaults to None.
        table_pattern(str, optional): A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only table name entries matching the search pattern are returned. If TablePattern is not specified, then all tables that match SchemaPatternare returned. If neither SchemaPattern or TablePattern are specified, then all tables are returned. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift_data.table.list_all(
                ctx, cluster_identifier=value, database=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift_data.table.list_all cluster_identifier=value, database=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift-data",
        operation="list_tables",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "ConnectedDatabase": connected_database,
            "Database": database,
            "DbUser": db_user,
            "MaxResults": max_results,
            "NextToken": next_token,
            "SchemaPattern": schema_pattern,
            "SecretArn": secret_arn,
            "TablePattern": table_pattern,
        },
    )
