"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, id_: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement results.

    Args:
        id_(str): The identifier of the SQL statement whose results are to be fetched. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates then number of the SQL statement. For example, d9b6c0c9-0747-4bf4-b142-e8883122f766:2 has a suffix of :2 that indicates the second SQL statement of a batch query. This identifier is returned by BatchExecuteStatment, ExecuteStatment, and ListStatements. .
        next_token(str, optional): A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift_data.statement.result.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift_data.statement.result.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift-data",
        operation="get_statement_result",
        op_kwargs={"Id": id_, "NextToken": next_token},
    )
