"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a running query. To be canceled, a query must be running.

    Args:
        id_(str): The identifier of the SQL statement to cancel. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. This identifier is returned by BatchExecuteStatment, ExecuteStatment, and ListStatements. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift_data.statement.init.cancel(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift_data.statement.init.cancel id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift-data",
        operation="cancel_statement",
        op_kwargs={"Id": id_},
    )


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The information includes when the query started, when it finished, the query status, the number of rows returned, and the SQL statement.

    Args:
        id_(str): The identifier of the SQL statement to describe. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example, d9b6c0c9-0747-4bf4-b142-e8883122f766:2 has a suffix of :2 that indicates the second SQL statement of a batch query. This identifier is returned by BatchExecuteStatment, ExecuteStatement, and ListStatements. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift_data.statement.init.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift_data.statement.init.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift-data",
        operation="describe_statement",
        op_kwargs={"Id": id_},
    )


async def execute(
    hub,
    ctx,
    cluster_identifier: str,
    database: str,
    sql: str,
    db_user: str = None,
    parameters: List = None,
    secret_arn: str = None,
    statement_name: str = None,
    with_event: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Runs an SQL statement, which can be data manipulation language (DML) or data definition language (DDL). This statement must be a single SQL statement. Depending on the authorization method, use one of the following combinations of request parameters:    Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret.    Temporary credentials - specify the cluster identifier, the database name, and the database user name. Permission to call the redshift:GetClusterCredentials operation is required to use this method.

    Args:
        cluster_identifier(str): The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials. .
        database(str): The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. .
        db_user(str, optional): The database user name. This parameter is required when authenticating using temporary credentials. . Defaults to None.
        parameters(List, optional): The parameters for the SQL statement. Defaults to None.
        secret_arn(str, optional): The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. . Defaults to None.
        sql(str): The SQL statement text to run. .
        statement_name(str, optional): The name of the SQL statement. You can name the SQL statement when you create it to identify the query. . Defaults to None.
        with_event(bool, optional): A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift_data.statement.init.execute(
                ctx, cluster_identifier=value, database=value, sql=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift_data.statement.init.execute cluster_identifier=value, database=value, sql=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift-data",
        operation="execute_statement",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "Database": database,
            "DbUser": db_user,
            "Parameters": parameters,
            "SecretArn": secret_arn,
            "Sql": sql,
            "StatementName": statement_name,
            "WithEvent": with_event,
        },
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    role_level: bool = None,
    statement_name: str = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List of SQL statements. By default, only finished statements are shown. A token is returned to page through the statement list.

    Args:
        max_results(int, optional): The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one response, then NextToken is returned to page through the results. . Defaults to None.
        next_token(str, optional): A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. . Defaults to None.
        role_level(bool, optional): A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM session are returned. The default is true. . Defaults to None.
        statement_name(str, optional): The name of the SQL statement specified as input to BatchExecuteStatement or ExecuteStatement to identify the query. You can list multiple statements by providing a prefix that matches the beginning of the statement name. For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of myStatement. Data API does a case-sensitive match of SQL statement names to the prefix value you provide. . Defaults to None.
        status(str, optional): The status of the SQL statement to list. Status values are defined as follows:    ABORTED - The query run was stopped by the user.    ALL - A status value that includes all query statuses. This value can be used to filter results.    FAILED - The query run failed.    FINISHED - The query has finished running.    PICKED - The query has been chosen to be run.    STARTED - The query run has started.    SUBMITTED - The query was submitted, but not yet processed.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift_data.statement.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift_data.statement.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift-data",
        operation="list_statements",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "RoleLevel": role_level,
            "StatementName": statement_name,
            "Status": status,
        },
    )
