"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    cluster_identifier: str,
    database: str,
    connected_database: str = None,
    db_user: str = None,
    max_results: int = None,
    next_token: str = None,
    schema_pattern: str = None,
    secret_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the schemas in a database. A token is returned to page through the schema list. Depending on the authorization method, use one of the following combinations of request parameters:    Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret.    Temporary credentials - specify the cluster identifier, the database name, and the database user name. Permission to call the redshift:GetClusterCredentials operation is required to use this method.

    Args:
        cluster_identifier(str): The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials. .
        connected_database(str, optional): A database name. The connected database is specified when you connect with your authentication credentials. . Defaults to None.
        database(str): The name of the database that contains the schemas to list. If ConnectedDatabase is not specified, this is also the database to connect to with your authentication credentials.
        db_user(str, optional): The database user name. This parameter is required when authenticating using temporary credentials. . Defaults to None.
        max_results(int, optional): The maximum number of schemas to return in the response. If more schemas exist than fit in one response, then NextToken is returned to page through the results. . Defaults to None.
        next_token(str, optional): A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request. . Defaults to None.
        schema_pattern(str, optional): A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more characters and "_" means match any one character. Only schema name entries matching the search pattern are returned. . Defaults to None.
        secret_arn(str, optional): The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift_data.schemas.list(
                ctx, cluster_identifier=value, database=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift_data.schemas.list cluster_identifier=value, database=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift-data",
        operation="list_schemas",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "ConnectedDatabase": connected_database,
            "Database": database,
            "DbUser": db_user,
            "MaxResults": max_results,
            "NextToken": next_token,
            "SchemaPattern": schema_pattern,
            "SecretArn": secret_arn,
        },
    )
