"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    cluster_identifier: str,
    database: str,
    sqls: List,
    db_user: str = None,
    secret_arn: str = None,
    statement_name: str = None,
    with_event: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Runs one or more SQL statements, which can be data manipulation language (DML) or data definition language (DDL). Depending on the authorization method, use one of the following combinations of request parameters:    Secrets Manager - specify the Amazon Resource Name (ARN) of the secret, the database name, and the cluster identifier that matches the cluster in the secret.    Temporary credentials - specify the cluster identifier, the database name, and the database user name. Permission to call the redshift:GetClusterCredentials operation is required to use this method.

    Args:
        cluster_identifier(str): The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials. .
        database(str): The name of the database. This parameter is required when authenticating using either Secrets Manager or temporary credentials. .
        db_user(str, optional): The database user name. This parameter is required when authenticating using temporary credentials. . Defaults to None.
        secret_arn(str, optional): The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager. . Defaults to None.
        sqls(List): One or more SQL statements to run. .
        statement_name(str, optional): The name of the SQL statements. You can name the SQL statements when you create them to identify the query. . Defaults to None.
        with_event(bool, optional): A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift_data.execute_statement.batch(
                ctx, cluster_identifier=value, database=value, sqls=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift_data.execute_statement.batch cluster_identifier=value, database=value, sqls=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift-data",
        operation="batch_execute_statement",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "Database": database,
            "DbUser": db_user,
            "SecretArn": secret_arn,
            "Sqls": sqls,
            "StatementName": statement_name,
            "WithEvent": with_event,
        },
    )
