"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    cluster_identifier: str,
    feature_type: str,
    limit_type: str,
    amount: int,
    period: str = None,
    breach_action: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the returned usage limit identifier.

    Args:
        cluster_identifier(str): The identifier of the cluster that you want to limit usage.
        feature_type(str): The Amazon Redshift feature that you want to limit.
        limit_type(str): The type of limit. Depending on the feature type, this can be based on a time duration or data size. If FeatureType is spectrum, then LimitType must be data-scanned. If FeatureType is concurrency-scaling, then LimitType must be time. .
        amount(int): The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number. .
        period(str, optional): The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly. . Defaults to None.
        breach_action(str, optional): The action that Amazon Redshift takes when the limit is reached. The default is log. For more information about this parameter, see UsageLimit. Defaults to None.
        tags(List, optional): A list of tag instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.usage_limit.create(
                ctx, cluster_identifier=value, feature_type=value, limit_type=value, amount=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.usage_limit.create cluster_identifier=value, feature_type=value, limit_type=value, amount=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_usage_limit",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "FeatureType": feature_type,
            "LimitType": limit_type,
            "Amount": amount,
            "Period": period,
            "BreachAction": breach_action,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, usage_limit_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a usage limit from a cluster.

    Args:
        usage_limit_id(str): The identifier of the usage limit to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.usage_limit.delete(ctx, usage_limit_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.usage_limit.delete usage_limit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_usage_limit",
        op_kwargs={"UsageLimitId": usage_limit_id},
    )


async def describe_all(
    hub,
    ctx,
    usage_limit_id: str = None,
    cluster_identifier: str = None,
    feature_type: str = None,
    max_records: int = None,
    marker: str = None,
    tag_keys: List = None,
    tag_values: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier, cluster identifier, and feature type parameters:   If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects for the current account in the current region are returned.   If usage limit identifier is provided, then the corresponding usage limit object is returned.   If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.   If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster and feature are returned.

    Args:
        usage_limit_id(str, optional): The identifier of the usage limit to describe. Defaults to None.
        cluster_identifier(str, optional): The identifier of the cluster for which you want to describe usage limits. Defaults to None.
        feature_type(str, optional): The feature type for which you want to describe usage limits. Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.  Default: 100  Constraints: minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeUsageLimits request exceed the value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.
        tag_keys(List, optional): A tag key or keys for which you want to return all matching usage limit objects that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called owner and environment. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the usage limit objects have either or both of these tag keys associated with them. Defaults to None.
        tag_values(List, optional): A tag value or values for which you want to return all matching usage limit objects that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called admin and test. If you specify both of these tag values in the request, Amazon Redshift returns a response with the usage limit objects that have either or both of these tag values associated with them. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.usage_limit.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.usage_limit.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_usage_limits",
        op_kwargs={
            "UsageLimitId": usage_limit_id,
            "ClusterIdentifier": cluster_identifier,
            "FeatureType": feature_type,
            "MaxRecords": max_records,
            "Marker": marker,
            "TagKeys": tag_keys,
            "TagValues": tag_values,
        },
    )


async def modify(
    hub, ctx, usage_limit_id: str, amount: int = None, breach_action: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a usage limit in a cluster. You can't modify the feature type or period of a usage limit.

    Args:
        usage_limit_id(str): The identifier of the usage limit to modify.
        amount(int, optional): The new limit amount. For more information about this parameter, see UsageLimit. . Defaults to None.
        breach_action(str, optional): The new action that Amazon Redshift takes when the limit is reached. For more information about this parameter, see UsageLimit. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.usage_limit.modify(ctx, usage_limit_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.usage_limit.modify usage_limit_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_usage_limit",
        op_kwargs={
            "UsageLimitId": usage_limit_id,
            "Amount": amount,
            "BreachAction": breach_action,
        },
    )
