"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, resource_name: str, tags: List) -> None:
    r"""
    **Autogenerated function**

    Adds tags to a cluster. A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an error and the attempt will fail. If you specify a key that already exists for the resource, the value for that key will be updated with the new value.

    Args:
        resource_name(str): The Amazon Resource Name (ARN) to which you want to add the tag or tags. For example, arn:aws:redshift:us-east-2:123456789:cluster:t1. .
        tags(List): One or more name/value pairs to add as tags to the specified resource. Each tag name is passed in with the parameter Key and the corresponding value is passed in with the parameter Value. The Key and Value parameters are separated by a comma (,). Separate multiple tags with a space. For example, --tags "Key"="owner","Value"="admin" "Key"="environment","Value"="test" "Key"="version","Value"="1.0". .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.tags.create(ctx, resource_name=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.tags.create resource_name=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_tags",
        op_kwargs={"ResourceName": resource_name, "Tags": tags},
    )


async def delete(hub, ctx, resource_name: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or tags.

    Args:
        resource_name(str): The Amazon Resource Name (ARN) from which you want to remove the tag or tags. For example, arn:aws:redshift:us-east-2:123456789:cluster:t1. .
        tag_keys(List): The tag key that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.tags.delete(ctx, resource_name=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.tags.delete resource_name=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_tags",
        op_kwargs={"ResourceName": resource_name, "TagKeys": tag_keys},
    )


async def describe(
    hub,
    ctx,
    resource_name: str = None,
    resource_type: str = None,
    max_records: int = None,
    marker: str = None,
    tag_keys: List = None,
    tag_values: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all tags for a given type of resource, such as clusters, snapshots, and so on. The following are limitations for DescribeTags:    You cannot specify an ARN and a resource-type value together in the same request.   You cannot use the MaxRecords and Marker parameters together with the ARN parameter.   The MaxRecords parameter can be a range from 10 to 50 results to return in a request.   If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match any combination of the specified keys and values. For example, if you have owner and environment for tag keys, and admin and test for tag values, all resources that have any combination of those values are returned. If both tag keys and values are omitted from the request, resources are returned regardless of whether they have tag keys or values associated with them.

    Args:
        resource_name(str, optional): The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For example, arn:aws:redshift:us-east-2:123456789:cluster:t1. . Defaults to None.
        resource_type(str, optional): The type of resource with which you want to view tags. Valid resource types are:    Cluster   CIDR/IP   EC2 security group   Snapshot   Cluster security group   Subnet group   HSM connection   HSM certificate   Parameter group   Snapshot copy grant   For more information about Amazon Redshift resource types and constructing ARNs, go to Specifying Policy Elements: Actions, Effects, Resources, and Principals in the Amazon Redshift Cluster Management Guide. . Defaults to None.
        max_records(int, optional): The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. . Defaults to None.
        marker(str, optional): A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the marker parameter and retrying the command. If the marker field is empty, all response records have been retrieved for the request. . Defaults to None.
        tag_keys(List, optional): A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called owner and environment. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them. Defaults to None.
        tag_values(List, optional): A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called admin and test. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.tags.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.tags.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_tags",
        op_kwargs={
            "ResourceName": resource_name,
            "ResourceType": resource_type,
            "MaxRecords": max_records,
            "Marker": marker,
            "TagKeys": tag_keys,
            "TagValues": tag_values,
        },
    )
