"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    cluster_identifier: str = None,
    table_restore_request_id: str = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the status of one or more table restore requests made using the RestoreTableFromClusterSnapshot API action. If you don't specify a value for the TableRestoreRequestId parameter, then DescribeTableRestoreStatus returns the status of all table restore requests ordered by the date and time of the request in ascending order. Otherwise DescribeTableRestoreStatus returns the status of the table specified by TableRestoreRequestId.

    Args:
        cluster_identifier(str, optional): The Amazon Redshift cluster that the table is being restored to. Defaults to None.
        table_restore_request_id(str, optional): The identifier of the table restore request to return status for. If you don't specify a TableRestoreRequestId value, then DescribeTableRestoreStatus returns the status of all in-progress table restore requests. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous DescribeTableRestoreStatus request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the MaxRecords parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.table.restore_status.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.table.restore_status.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_table_restore_status",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "TableRestoreRequestId": table_restore_request_id,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
