"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def restore(
    hub,
    ctx,
    cluster_identifier: str,
    snapshot_identifier: str,
    source_database_name: str,
    source_table_name: str,
    new_table_name: str,
    source_schema_name: str = None,
    target_database_name: str = None,
    target_schema_name: str = None,
    enable_case_sensitive_identifier: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create the new table within the Amazon Redshift cluster that the snapshot was taken from. You cannot use RestoreTableFromClusterSnapshot to restore a table with the same name as an existing table in an Amazon Redshift cluster. That is, you cannot overwrite an existing table in a cluster with a restored table. If you want to replace your original table with a new, restored table, then rename or drop your original table before you call RestoreTableFromClusterSnapshot. When you have renamed your original table, then you can pass the original name of the table as the NewTableName parameter value in the call to RestoreTableFromClusterSnapshot. This way, you can replace the original table with the table created from the snapshot.

    Args:
        cluster_identifier(str): The identifier of the Amazon Redshift cluster to restore the table to.
        snapshot_identifier(str): The identifier of the snapshot to restore the table from. This snapshot must have been created from the Amazon Redshift cluster specified by the ClusterIdentifier parameter.
        source_database_name(str): The name of the source database that contains the table to restore from.
        source_schema_name(str, optional): The name of the source schema that contains the table to restore from. If you do not specify a SourceSchemaName value, the default is public. Defaults to None.
        source_table_name(str): The name of the source table to restore from.
        target_database_name(str, optional): The name of the database to restore the table to. Defaults to None.
        target_schema_name(str, optional): The name of the schema to restore the table to. Defaults to None.
        new_table_name(str): The name of the table to create as a result of the current request.
        enable_case_sensitive_identifier(bool, optional): Indicates whether name identifiers for database, schema, and table are case sensitive. If true, the names are case sensitive. If false (default), the names are not case sensitive. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.table.from_cluster_snapshot.restore(
                ctx,
                cluster_identifier=value,
                snapshot_identifier=value,
                source_database_name=value,
                source_table_name=value,
                new_table_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.table.from_cluster_snapshot.restore cluster_identifier=value, snapshot_identifier=value, source_database_name=value, source_table_name=value, new_table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="restore_table_from_cluster_snapshot",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "SnapshotIdentifier": snapshot_identifier,
            "SourceDatabaseName": source_database_name,
            "SourceSchemaName": source_schema_name,
            "SourceTableName": source_table_name,
            "TargetDatabaseName": target_database_name,
            "TargetSchemaName": target_schema_name,
            "NewTableName": new_table_name,
            "EnableCaseSensitiveIdentifier": enable_case_sensitive_identifier,
        },
    )
