"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    schedule_definitions: List = None,
    schedule_identifier: str = None,
    schedule_description: str = None,
    tags: List = None,
    dry_run: bool = None,
    next_invocations: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup schedule.

    Args:
        schedule_definitions(List, optional): The definition of the snapshot schedule. The definition is made up of schedule expressions, for example "cron(30 12 *)" or "rate(12 hours)". . Defaults to None.
        schedule_identifier(str, optional): A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed for the identifier. Defaults to None.
        schedule_description(str, optional): The description of the snapshot schedule. Defaults to None.
        tags(List, optional): An optional set of tags you can use to search for the schedule. Defaults to None.
        dry_run(bool, optional): . Defaults to None.
        next_invocations(int, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.schedule.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.schedule.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_snapshot_schedule",
        op_kwargs={
            "ScheduleDefinitions": schedule_definitions,
            "ScheduleIdentifier": schedule_identifier,
            "ScheduleDescription": schedule_description,
            "Tags": tags,
            "DryRun": dry_run,
            "NextInvocations": next_invocations,
        },
    )


async def delete(hub, ctx, schedule_identifier: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a snapshot schedule.

    Args:
        schedule_identifier(str): A unique identifier of the snapshot schedule to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.schedule.delete(
                ctx, schedule_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.schedule.delete schedule_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_snapshot_schedule",
        op_kwargs={"ScheduleIdentifier": schedule_identifier},
    )


async def describe_all(
    hub,
    ctx,
    cluster_identifier: str = None,
    schedule_identifier: str = None,
    tag_keys: List = None,
    tag_values: List = None,
    marker: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of snapshot schedules.

    Args:
        cluster_identifier(str, optional): The unique identifier for the cluster whose snapshot schedules you want to view. Defaults to None.
        schedule_identifier(str, optional): A unique identifier for a snapshot schedule. Defaults to None.
        tag_keys(List, optional): The key value for a snapshot schedule tag. Defaults to None.
        tag_values(List, optional): The value corresponding to the key of the snapshot schedule tag. Defaults to None.
        marker(str, optional): A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the marker parameter and retrying the command. If the marker field is empty, all response records have been retrieved for the request. Defaults to None.
        max_records(int, optional): The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.schedule.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.schedule.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_snapshot_schedules",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "ScheduleIdentifier": schedule_identifier,
            "TagKeys": tag_keys,
            "TagValues": tag_values,
            "Marker": marker,
            "MaxRecords": max_records,
        },
    )


async def modify(
    hub, ctx, schedule_identifier: str, schedule_definitions: List
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a snapshot schedule. Any schedule associated with a cluster is modified asynchronously.

    Args:
        schedule_identifier(str): A unique alphanumeric identifier of the schedule to modify.
        schedule_definitions(List): An updated list of schedule definitions. A schedule definition is made up of schedule expressions, for example, "cron(30 12 *)" or "rate(12 hours)".

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.schedule.modify(
                ctx, schedule_identifier=value, schedule_definitions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.schedule.modify schedule_identifier=value, schedule_definitions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_snapshot_schedule",
        op_kwargs={
            "ScheduleIdentifier": schedule_identifier,
            "ScheduleDefinitions": schedule_definitions,
        },
    )
