"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(
    hub, ctx, cluster_identifier: str, retention_period: int, manual: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the number of days to retain snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. By default, this operation only changes the retention period of copied automated snapshots. The retention periods for both new and existing copied automated snapshots are updated with the new retention period. You can set the manual option to change only the retention periods of copied manual snapshots. If you set this option, only newly copied manual snapshots have the new retention period.

    Args:
        cluster_identifier(str): The unique identifier of the cluster for which you want to change the retention period for either automated or manual snapshots that are copied to a destination Amazon Web Services Region. Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.
        retention_period(int): The number of days to retain automated snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. By default, this only changes the retention period of copied automated snapshots.  If you decrease the retention period for automated snapshots that are copied to a destination Amazon Web Services Region, Amazon Redshift deletes any existing automated snapshots that were copied to the destination Amazon Web Services Region and that fall outside of the new retention period. Constraints: Must be at least 1 and no more than 35 for automated snapshots.  If you specify the manual option, only newly copied manual snapshots will have the new retention period.  If you specify the value of -1 newly copied manual snapshots are retained indefinitely. Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.
        manual(bool, optional): Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.copy.retention_period.modify(
                ctx, cluster_identifier=value, retention_period=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.copy.retention_period.modify cluster_identifier=value, retention_period=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_snapshot_copy_retention_period",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "RetentionPeriod": retention_period,
            "Manual": manual,
        },
    )
