"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables the automatic copying of snapshots from one region to another region for a specified cluster. If your cluster and its snapshots are encrypted using a customer master key (CMK) from Key Management Service, use DeleteSnapshotCopyGrant to delete the grant that grants Amazon Redshift permission to the CMK in the destination region.

    Args:
        cluster_identifier(str): The unique identifier of the source cluster that you want to disable copying of snapshots to a destination region. Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.copy.init.disable(
                ctx, cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.copy.init.disable cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="disable_snapshot_copy",
        op_kwargs={"ClusterIdentifier": cluster_identifier},
    )


async def enable(
    hub,
    ctx,
    cluster_identifier: str,
    destination_region: str,
    retention_period: int = None,
    snapshot_copy_grant_name: str = None,
    manual_snapshot_retention_period: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Enables the automatic copy of snapshots from one region to another region for a specified cluster.

    Args:
        cluster_identifier(str): The unique identifier of the source cluster to copy snapshots from. Constraints: Must be the valid name of an existing cluster that does not already have cross-region snapshot copy enabled.
        destination_region(str): The destination Amazon Web Services Region that you want to copy snapshots to. Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see Regions and Endpoints in the Amazon Web Services General Reference. .
        retention_period(int, optional): The number of days to retain automated snapshots in the destination region after they are copied from the source region. Default: 7. Constraints: Must be at least 1 and no more than 35. Defaults to None.
        snapshot_copy_grant_name(str, optional): The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted cluster are copied to the destination region. Defaults to None.
        manual_snapshot_retention_period(int, optional): The number of days to retain newly copied snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. If the value is -1, the manual snapshot is retained indefinitely.  The value must be either -1 or an integer between 1 and 3,653. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.copy.init.enable(
                ctx, cluster_identifier=value, destination_region=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.copy.init.enable cluster_identifier=value, destination_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="enable_snapshot_copy",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "DestinationRegion": destination_region,
            "RetentionPeriod": retention_period,
            "SnapshotCopyGrantName": snapshot_copy_grant_name,
            "ManualSnapshotRetentionPeriod": manual_snapshot_retention_period,
        },
    )
