"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, snapshot_copy_grant_name: str, kms_key_id: str = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a snapshot copy grant that permits Amazon Redshift to use a customer master key (CMK) from Key Management Service (KMS) to encrypt copied snapshots in a destination region.  For more information about managing snapshot copy grants, go to Amazon Redshift Database Encryption in the Amazon Redshift Cluster Management Guide.

    Args:
        snapshot_copy_grant_name(str): The name of the snapshot copy grant. This name must be unique in the region for the Amazon Web Services account. Constraints:   Must contain from 1 to 63 alphanumeric characters or hyphens.   Alphabetic characters must be lowercase.   First character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.   Must be unique for all clusters within an Amazon Web Services account.  .
        kms_key_id(str, optional): The unique identifier of the customer master key (CMK) to which to grant Amazon Redshift permission. If no key is specified, the default key is used. Defaults to None.
        tags(List, optional): A list of tag instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.copy.grant.create(
                ctx, snapshot_copy_grant_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.copy.grant.create snapshot_copy_grant_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_snapshot_copy_grant",
        op_kwargs={
            "SnapshotCopyGrantName": snapshot_copy_grant_name,
            "KmsKeyId": kms_key_id,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, snapshot_copy_grant_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified snapshot copy grant.

    Args:
        snapshot_copy_grant_name(str): The name of the snapshot copy grant to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.copy.grant.delete(
                ctx, snapshot_copy_grant_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.copy.grant.delete snapshot_copy_grant_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_snapshot_copy_grant",
        op_kwargs={"SnapshotCopyGrantName": snapshot_copy_grant_name},
    )


async def describe_all(
    hub,
    ctx,
    snapshot_copy_grant_name: str = None,
    max_records: int = None,
    marker: str = None,
    tag_keys: List = None,
    tag_values: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.  For more information about managing snapshot copy grants, go to Amazon Redshift Database Encryption in the Amazon Redshift Cluster Management Guide.

    Args:
        snapshot_copy_grant_name(str, optional): The name of the snapshot copy grant. Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.  Default: 100  Constraints: minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeSnapshotCopyGrant request exceed the value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request.  Constraints: You can specify either the SnapshotCopyGrantName parameter or the Marker parameter, but not both. . Defaults to None.
        tag_keys(List, optional): A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called owner and environment. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them. Defaults to None.
        tag_values(List, optional): A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called admin and test. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.copy.grant.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.copy.grant.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_snapshot_copy_grants",
        op_kwargs={
            "SnapshotCopyGrantName": snapshot_copy_grant_name,
            "MaxRecords": max_records,
            "Marker": marker,
            "TagKeys": tag_keys,
            "TagValues": tag_values,
        },
    )
