"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def authorize(
    hub,
    ctx,
    snapshot_identifier: str,
    account_with_restore_access: str,
    snapshot_cluster_identifier: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Authorizes the specified Amazon Web Services account to restore the specified snapshot.  For more information about working with snapshots, go to Amazon Redshift Snapshots in the Amazon Redshift Cluster Management Guide.

    Args:
        snapshot_identifier(str): The identifier of the snapshot the account is authorized to restore.
        snapshot_cluster_identifier(str, optional): The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name. Defaults to None.
        account_with_restore_access(str): The identifier of the Amazon Web Services account authorized to restore the specified snapshot. To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.access.authorize(
                ctx, snapshot_identifier=value, account_with_restore_access=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.access.authorize snapshot_identifier=value, account_with_restore_access=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="authorize_snapshot_access",
        op_kwargs={
            "SnapshotIdentifier": snapshot_identifier,
            "SnapshotClusterIdentifier": snapshot_cluster_identifier,
            "AccountWithRestoreAccess": account_with_restore_access,
        },
    )


async def revoke(
    hub,
    ctx,
    snapshot_identifier: str,
    account_with_restore_access: str,
    snapshot_cluster_identifier: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes the ability of the specified Amazon Web Services account to restore the specified snapshot. If the account is currently restoring the snapshot, the restore will run to completion.  For more information about working with snapshots, go to Amazon Redshift Snapshots in the Amazon Redshift Cluster Management Guide.

    Args:
        snapshot_identifier(str): The identifier of the snapshot that the account can no longer access.
        snapshot_cluster_identifier(str, optional): The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name. Defaults to None.
        account_with_restore_access(str): The identifier of the Amazon Web Services account that can no longer restore the specified snapshot.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.snapshot.access.revoke(
                ctx, snapshot_identifier=value, account_with_restore_access=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.snapshot.access.revoke snapshot_identifier=value, account_with_restore_access=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="revoke_snapshot_access",
        op_kwargs={
            "SnapshotIdentifier": snapshot_identifier,
            "SnapshotClusterIdentifier": snapshot_cluster_identifier,
            "AccountWithRestoreAccess": account_with_restore_access,
        },
    )
