"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    scheduled_action_name: str,
    target_action: Dict,
    schedule: str,
    iam_role: str,
    scheduled_action_description: str = None,
    start_time: str = None,
    end_time: str = None,
    enable: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the ResizeCluster API operation.

    Args:
        scheduled_action_name(str): The name of the scheduled action. The name must be unique within an account. For more information about this parameter, see ScheduledAction. .
        target_action(Dict): A JSON format string of the Amazon Redshift API operation with input parameters. For more information about this parameter, see ScheduledAction. .
        schedule(str): The schedule in at( ) or cron( ) format. For more information about this parameter, see ScheduledAction.
        iam_role(str): The IAM role to assume to run the target action. For more information about this parameter, see ScheduledAction. .
        scheduled_action_description(str, optional): The description of the scheduled action. . Defaults to None.
        start_time(str, optional): The start time in UTC of the scheduled action. Before this time, the scheduled action does not trigger. For more information about this parameter, see ScheduledAction. Defaults to None.
        end_time(str, optional): The end time in UTC of the scheduled action. After this time, the scheduled action does not trigger. For more information about this parameter, see ScheduledAction. . Defaults to None.
        enable(bool, optional): If true, the schedule is enabled. If false, the scheduled action does not trigger. For more information about state of the scheduled action, see ScheduledAction. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.scheduled_action.create(
                ctx,
                scheduled_action_name=value,
                target_action=value,
                schedule=value,
                iam_role=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.scheduled_action.create scheduled_action_name=value, target_action=value, schedule=value, iam_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_scheduled_action",
        op_kwargs={
            "ScheduledActionName": scheduled_action_name,
            "TargetAction": target_action,
            "Schedule": schedule,
            "IamRole": iam_role,
            "ScheduledActionDescription": scheduled_action_description,
            "StartTime": start_time,
            "EndTime": end_time,
            "Enable": enable,
        },
    )


async def delete(hub, ctx, scheduled_action_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a scheduled action.

    Args:
        scheduled_action_name(str): The name of the scheduled action to delete. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.scheduled_action.delete(
                ctx, scheduled_action_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.scheduled_action.delete scheduled_action_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_scheduled_action",
        op_kwargs={"ScheduledActionName": scheduled_action_name},
    )


async def describe_all(
    hub,
    ctx,
    scheduled_action_name: str = None,
    target_action_type: str = None,
    start_time: str = None,
    end_time: str = None,
    active: bool = None,
    filters: List = None,
    marker: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes properties of scheduled actions.

    Args:
        scheduled_action_name(str, optional): The name of the scheduled action to retrieve. . Defaults to None.
        target_action_type(str, optional): The type of the scheduled actions to retrieve. . Defaults to None.
        start_time(str, optional): The start time in UTC of the scheduled actions to retrieve. Only active scheduled actions that have invocations after this time are retrieved. Defaults to None.
        end_time(str, optional): The end time in UTC of the scheduled action to retrieve. Only active scheduled actions that have invocations before this time are retrieved. Defaults to None.
        active(bool, optional): If true, retrieve only active scheduled actions. If false, retrieve only disabled scheduled actions. . Defaults to None.
        filters(List, optional): List of scheduled action filters. . Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeScheduledActions request exceed the value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.  Default: 100  Constraints: minimum 20, maximum 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.scheduled_action.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.scheduled_action.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_scheduled_actions",
        op_kwargs={
            "ScheduledActionName": scheduled_action_name,
            "TargetActionType": target_action_type,
            "StartTime": start_time,
            "EndTime": end_time,
            "Active": active,
            "Filters": filters,
            "Marker": marker,
            "MaxRecords": max_records,
        },
    )


async def modify(
    hub,
    ctx,
    scheduled_action_name: str,
    target_action: Dict = None,
    schedule: str = None,
    iam_role: str = None,
    scheduled_action_description: str = None,
    start_time: str = None,
    end_time: str = None,
    enable: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a scheduled action.

    Args:
        scheduled_action_name(str): The name of the scheduled action to modify. .
        target_action(Dict, optional): A modified JSON format of the scheduled action. For more information about this parameter, see ScheduledAction. . Defaults to None.
        schedule(str, optional): A modified schedule in either at( ) or cron( ) format. For more information about this parameter, see ScheduledAction. Defaults to None.
        iam_role(str, optional): A different IAM role to assume to run the target action. For more information about this parameter, see ScheduledAction. Defaults to None.
        scheduled_action_description(str, optional): A modified description of the scheduled action. . Defaults to None.
        start_time(str, optional): A modified start time of the scheduled action. For more information about this parameter, see ScheduledAction. . Defaults to None.
        end_time(str, optional): A modified end time of the scheduled action. For more information about this parameter, see ScheduledAction. . Defaults to None.
        enable(bool, optional): A modified enable flag of the scheduled action. If true, the scheduled action is active. If false, the scheduled action is disabled. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.scheduled_action.modify(
                ctx, scheduled_action_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.scheduled_action.modify scheduled_action_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_scheduled_action",
        op_kwargs={
            "ScheduledActionName": scheduled_action_name,
            "TargetAction": target_action,
            "Schedule": schedule,
            "IamRole": iam_role,
            "ScheduledActionDescription": scheduled_action_description,
            "StartTime": start_time,
            "EndTime": end_time,
            "Enable": enable,
        },
    )
