"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a resize operation for a cluster.

    Args:
        cluster_identifier(str): The unique identifier for the cluster that you want to cancel a resize operation for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.resize.cancel(ctx, cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.resize.cancel cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="cancel_resize",
        op_kwargs={"ClusterIdentifier": cluster_identifier},
    )


async def describe(hub, ctx, cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the last resize operation for the specified cluster. If no resize operation has ever been initiated for the specified cluster, a HTTP 404 error is returned. If a resize operation was initiated and completed, the status of the resize remains as SUCCEEDED until the next resize.  A resize operation can be requested using ModifyCluster and specifying a different number or type of nodes for the cluster.

    Args:
        cluster_identifier(str): The unique identifier of a cluster whose resize progress you are requesting. This parameter is case-sensitive. By default, resize operations for all clusters defined for an Amazon Web Services account are returned.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.resize.describe(ctx, cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.resize.describe cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_resize",
        op_kwargs={"ClusterIdentifier": cluster_identifier},
    )
