"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    reserved_node_offering_id: str = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you. These descriptions help you determine which reserve node offering you want to purchase. You then use the unique offering ID in you call to PurchaseReservedNodeOffering to reserve one or more nodes for your Amazon Redshift cluster.   For more information about reserved node offerings, go to Purchasing Reserved Nodes in the Amazon Redshift Cluster Management Guide.

    Args:
        reserved_node_offering_id(str, optional): The unique identifier for the offering. Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.  Default: 100  Constraints: minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeReservedNodeOfferings request exceed the value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.reserved_node.offering.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.reserved_node.offering.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_reserved_node_offerings",
        op_kwargs={
            "ReservedNodeOfferingId": reserved_node_offering_id,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def purchase(
    hub, ctx, reserved_node_offering_id: str, node_count: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of reserved node offerings. You can purchase one or more of the offerings. You can call the DescribeReservedNodeOfferings API to obtain the available reserved node offerings. You can call this API by providing a specific reserved node offering and the number of nodes you want to reserve.   For more information about reserved node offerings, go to Purchasing Reserved Nodes in the Amazon Redshift Cluster Management Guide.

    Args:
        reserved_node_offering_id(str): The unique identifier of the reserved node offering you want to purchase.
        node_count(int, optional): The number of reserved nodes that you want to purchase. Default: 1 . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.reserved_node.offering.purchase(
                ctx, reserved_node_offering_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.reserved_node.offering.purchase reserved_node_offering_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="purchase_reserved_node_offering",
        op_kwargs={
            "ReservedNodeOfferingId": reserved_node_offering_id,
            "NodeCount": node_count,
        },
    )
