"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, reserved_node_id: str, max_records: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given DC1 reserved node.

    Args:
        reserved_node_id(str): A string representing the node identifier for the DC1 Reserved Node to be exchanged.
        max_records(int, optional): An integer setting the maximum number of ReservedNodeOfferings to retrieve. Defaults to None.
        marker(str, optional): A value that indicates the starting point for the next set of ReservedNodeOfferings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.reserved_node.exchange.offering.get_all(
                ctx, reserved_node_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.reserved_node.exchange.offering.get_all reserved_node_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="get_reserved_node_exchange_offerings",
        op_kwargs={
            "ReservedNodeId": reserved_node_id,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
