"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def accept(
    hub, ctx, reserved_node_id: str, target_reserved_node_offering_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type, or number of nodes) and no additional costs.

    Args:
        reserved_node_id(str): A string representing the node identifier of the DC1 Reserved Node to be exchanged.
        target_reserved_node_offering_id(str): The unique identifier of the DC2 Reserved Node offering to be used for the exchange. You can obtain the value for the parameter by calling GetReservedNodeExchangeOfferings .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.reserved_node.exchange.init.accept(
                ctx, reserved_node_id=value, target_reserved_node_offering_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.reserved_node.exchange.init.accept reserved_node_id=value, target_reserved_node_offering_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="accept_reserved_node_exchange",
        op_kwargs={
            "ReservedNodeId": reserved_node_id,
            "TargetReservedNodeOfferingId": target_reserved_node_offering_id,
        },
    )
