"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    account_id: str,
    cluster_identifier: str,
    database_name: str,
    partner_name: str,
    status: str,
    status_message: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the status of a partner integration.

    Args:
        account_id(str): The Amazon Web Services account ID that owns the cluster.
        cluster_identifier(str): The cluster identifier of the cluster whose partner integration status is being updated.
        database_name(str): The name of the database whose partner integration status is being updated.
        partner_name(str): The name of the partner whose integration status is being updated.
        status(str): The value of the updated status.
        status_message(str, optional): The status message provided by the partner. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.partner.status.update(
                ctx,
                account_id=value,
                cluster_identifier=value,
                database_name=value,
                partner_name=value,
                status=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.partner.status.update account_id=value, cluster_identifier=value, database_name=value, partner_name=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="update_partner_status",
        op_kwargs={
            "AccountId": account_id,
            "ClusterIdentifier": cluster_identifier,
            "DatabaseName": database_name,
            "PartnerName": partner_name,
            "Status": status,
            "StatusMessage": status_message,
        },
    )
