"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(
    hub,
    ctx,
    account_id: str,
    cluster_identifier: str,
    database_name: str,
    partner_name: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the specified database. To complete the integration, you also set up the integration on the partner website.

    Args:
        account_id(str): The Amazon Web Services account ID that owns the cluster.
        cluster_identifier(str): The cluster identifier of the cluster that receives data from the partner.
        database_name(str): The name of the database that receives data from the partner.
        partner_name(str): The name of the partner that is authorized to send data.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.partner.init.add(
                ctx,
                account_id=value,
                cluster_identifier=value,
                database_name=value,
                partner_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.partner.init.add account_id=value, cluster_identifier=value, database_name=value, partner_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="add_partner",
        op_kwargs={
            "AccountId": account_id,
            "ClusterIdentifier": cluster_identifier,
            "DatabaseName": database_name,
            "PartnerName": partner_name,
        },
    )


async def delete(
    hub,
    ctx,
    account_id: str,
    cluster_identifier: str,
    database_name: str,
    partner_name: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted at the partner's website.

    Args:
        account_id(str): The Amazon Web Services account ID that owns the cluster.
        cluster_identifier(str): The cluster identifier of the cluster that receives data from the partner.
        database_name(str): The name of the database that receives data from the partner.
        partner_name(str): The name of the partner that is authorized to send data.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.partner.init.delete(
                ctx,
                account_id=value,
                cluster_identifier=value,
                database_name=value,
                partner_name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.partner.init.delete account_id=value, cluster_identifier=value, database_name=value, partner_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_partner",
        op_kwargs={
            "AccountId": account_id,
            "ClusterIdentifier": cluster_identifier,
            "DatabaseName": database_name,
            "PartnerName": partner_name,
        },
    )


async def describe_all(
    hub,
    ctx,
    account_id: str,
    cluster_identifier: str,
    database_name: str = None,
    partner_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the partner integrations defined for a cluster.

    Args:
        account_id(str): The Amazon Web Services account ID that owns the cluster.
        cluster_identifier(str): The cluster identifier of the cluster whose partner integration is being described.
        database_name(str, optional): The name of the database whose partner integration is being described. If database name is not specified, then all databases in the cluster are described. Defaults to None.
        partner_name(str, optional): The name of the partner that is being described. If partner name is not specified, then all partner integrations are described. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.partner.init.describe_all(
                ctx, account_id=value, cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.partner.init.describe_all account_id=value, cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_partners",
        op_kwargs={
            "AccountId": account_id,
            "ClusterIdentifier": cluster_identifier,
            "DatabaseName": database_name,
            "PartnerName": partner_name,
        },
    )
