"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    action_type: str,
    cluster_identifier: str = None,
    snapshot_identifier: str = None,
    owner_account: str = None,
    filters: List = None,
    marker: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the specified action type.

    Args:
        action_type(str): The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster. .
        cluster_identifier(str, optional): The identifier of the cluster to evaluate for possible node configurations. Defaults to None.
        snapshot_identifier(str, optional): The identifier of the snapshot to evaluate for possible node configurations. Defaults to None.
        owner_account(str, optional): The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot. Defaults to None.
        filters(List, optional): A set of name, operator, and value items to filter the results. Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeNodeConfigurationOptions request exceed the value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.  Default: 500  Constraints: minimum 100, maximum 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.node_configuration_option.describe_all(
                ctx, action_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.node_configuration_option.describe_all action_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_node_configuration_options",
        op_kwargs={
            "ActionType": action_type,
            "ClusterIdentifier": cluster_identifier,
            "SnapshotIdentifier": snapshot_identifier,
            "OwnerAccount": owner_account,
            "Filters": filters,
            "Marker": marker,
            "MaxRecords": max_records,
        },
    )
