"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    snapshot_identifier_list: List,
    manual_snapshot_retention_period: int = None,
    force: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the settings for a set of cluster snapshots.

    Args:
        snapshot_identifier_list(List): A list of snapshot identifiers you want to modify.
        manual_snapshot_retention_period(int, optional): The number of days that a manual snapshot is retained. If you specify the value -1, the manual snapshot is retained indefinitely. The number must be either -1 or an integer between 1 and 3,653. If you decrease the manual snapshot retention period from its current value, existing manual snapshots that fall outside of the new retention period will return an error. If you want to suppress the errors and delete the snapshots, use the force option. . Defaults to None.
        force(bool, optional): A boolean value indicating whether to override an exception if the retention period has passed. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.modify_cluster_snapshot.batch(
                ctx, snapshot_identifier_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.modify_cluster_snapshot.batch snapshot_identifier_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="batch_modify_cluster_snapshots",
        op_kwargs={
            "SnapshotIdentifierList": snapshot_identifier_list,
            "ManualSnapshotRetentionPeriod": manual_snapshot_retention_period,
            "Force": force,
        },
    )
