"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon Redshift cluster.

    Args:
        cluster_identifier(str): The identifier of the cluster from which to get the logging status. Example: examplecluster .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.logging.status.describe(ctx, cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.logging.status.describe cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_logging_status",
        op_kwargs={"ClusterIdentifier": cluster_identifier},
    )
