"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.

    Args:
        cluster_identifier(str): The identifier of the cluster on which logging is to be stopped. Example: examplecluster .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.logging.init.disable(ctx, cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.logging.init.disable cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="disable_logging",
        op_kwargs={"ClusterIdentifier": cluster_identifier},
    )


async def enable(
    hub, ctx, cluster_identifier: str, bucket_name: str, s3_key_prefix: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.

    Args:
        cluster_identifier(str): The identifier of the cluster on which logging is to be started. Example: examplecluster .
        bucket_name(str): The name of an existing S3 bucket where the log files are to be stored. Constraints:   Must be in the same region as the cluster   The cluster must have read bucket and put object permissions  .
        s3_key_prefix(str, optional): The prefix applied to the log file names. Constraints:   Cannot exceed 512 characters   Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\), or control characters. The hexadecimal codes for invalid characters are:    x00 to x20   x22   x27   x5c   x7f or larger    . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.logging.init.enable(
                ctx, cluster_identifier=value, bucket_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.logging.init.enable cluster_identifier=value, bucket_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="enable_logging",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "BucketName": bucket_name,
            "S3KeyPrefix": s3_key_prefix,
        },
    )
