"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    hsm_configuration_identifier: str,
    description: str,
    hsm_ip_address: str,
    hsm_partition_name: str,
    hsm_partition_password: str,
    hsm_server_public_certificate: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM. In addition to creating an HSM configuration, you must also create an HSM client certificate. For more information, go to Hardware Security Modules in the Amazon Redshift Cluster Management Guide.

    Args:
        hsm_configuration_identifier(str): The identifier to be assigned to the new Amazon Redshift HSM configuration.
        description(str): A text description of the HSM configuration to be created.
        hsm_ip_address(str): The IP address that the Amazon Redshift cluster must use to access the HSM.
        hsm_partition_name(str): The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.
        hsm_partition_password(str): The password required to access the HSM partition.
        hsm_server_public_certificate(str): The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
        tags(List, optional): A list of tag instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.hsm.configuration.create(
                ctx,
                hsm_configuration_identifier=value,
                description=value,
                hsm_ip_address=value,
                hsm_partition_name=value,
                hsm_partition_password=value,
                hsm_server_public_certificate=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.hsm.configuration.create hsm_configuration_identifier=value, description=value, hsm_ip_address=value, hsm_partition_name=value, hsm_partition_password=value, hsm_server_public_certificate=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_hsm_configuration",
        op_kwargs={
            "HsmConfigurationIdentifier": hsm_configuration_identifier,
            "Description": description,
            "HsmIpAddress": hsm_ip_address,
            "HsmPartitionName": hsm_partition_name,
            "HsmPartitionPassword": hsm_partition_password,
            "HsmServerPublicCertificate": hsm_server_public_certificate,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, hsm_configuration_identifier: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified Amazon Redshift HSM configuration.

    Args:
        hsm_configuration_identifier(str): The identifier of the Amazon Redshift HSM configuration to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.hsm.configuration.delete(
                ctx, hsm_configuration_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.hsm.configuration.delete hsm_configuration_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_hsm_configuration",
        op_kwargs={"HsmConfigurationIdentifier": hsm_configuration_identifier},
    )


async def describe_all(
    hub,
    ctx,
    hsm_configuration_identifier: str = None,
    max_records: int = None,
    marker: str = None,
    tag_keys: List = None,
    tag_values: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified, returns information about all the HSM configurations owned by your Amazon Web Services account. If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that match any combination of the specified keys and values. For example, if you have owner and environment for tag keys, and admin and test for tag values, all HSM connections that have any combination of those values are returned. If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they have tag keys or values associated with them.

    Args:
        hsm_configuration_identifier(str, optional): The identifier of a specific Amazon Redshift HSM configuration to be described. If no identifier is specified, information is returned for all HSM configurations owned by your Amazon Web Services account. Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.  Default: 100  Constraints: minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeHsmConfigurations request exceed the value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.
        tag_keys(List, optional): A tag key or keys for which you want to return all matching HSM configurations that are associated with the specified key or keys. For example, suppose that you have HSM configurations that are tagged with keys called owner and environment. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag keys associated with them. Defaults to None.
        tag_values(List, optional): A tag value or values for which you want to return all matching HSM configurations that are associated with the specified tag value or values. For example, suppose that you have HSM configurations that are tagged with values called admin and test. If you specify both of these tag values in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag values associated with them. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.hsm.configuration.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.hsm.configuration.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_hsm_configurations",
        op_kwargs={
            "HsmConfigurationIdentifier": hsm_configuration_identifier,
            "MaxRecords": max_records,
            "Marker": marker,
            "TagKeys": tag_keys,
            "TagValues": tag_values,
        },
    )
