"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def restore(
    hub,
    ctx,
    cluster_identifier: str,
    snapshot_identifier: str,
    snapshot_cluster_identifier: str = None,
    port: int = None,
    availability_zone: str = None,
    allow_version_upgrade: bool = None,
    cluster_subnet_group_name: str = None,
    publicly_accessible: bool = None,
    owner_account: str = None,
    hsm_client_certificate_identifier: str = None,
    hsm_configuration_identifier: str = None,
    elastic_ip: str = None,
    cluster_parameter_group_name: str = None,
    cluster_security_groups: List = None,
    vpc_security_group_ids: List = None,
    preferred_maintenance_window: str = None,
    automated_snapshot_retention_period: int = None,
    manual_snapshot_retention_period: int = None,
    kms_key_id: str = None,
    node_type: str = None,
    enhanced_vpc_routing: bool = None,
    additional_info: str = None,
    iam_roles: List = None,
    maintenance_track_name: str = None,
    snapshot_schedule_identifier: str = None,
    number_of_nodes: int = None,
    availability_zone_relocation: bool = None,
    aqua_configuration_status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting cluster with the same configuration as the original cluster from which the snapshot was created, except that the new cluster is created with the default cluster security and parameter groups. After Amazon Redshift creates the cluster, you can use the ModifyCluster API to associate a different security group and different parameter group with the restored cluster. If you are using a DS node type, you can also choose to change to another DS node type of the same size during restore. If you restore a cluster into a VPC, you must provide a cluster subnet group where you want the cluster restored.  For more information about working with snapshots, go to Amazon Redshift Snapshots in the Amazon Redshift Cluster Management Guide.

    Args:
        cluster_identifier(str): The identifier of the cluster that will be created from restoring the snapshot. Constraints:   Must contain from 1 to 63 alphanumeric characters or hyphens.   Alphabetic characters must be lowercase.   First character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.   Must be unique for all clusters within an Amazon Web Services account.  .
        snapshot_identifier(str): The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive. Example: my-snapshot-id .
        snapshot_cluster_identifier(str, optional): The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name. Defaults to None.
        port(int, optional): The port number on which the cluster accepts connections. Default: The same port as the original cluster. Constraints: Must be between 1115 and 65535. Defaults to None.
        availability_zone(str, optional): The Amazon EC2 Availability Zone in which to restore the cluster. Default: A random, system-chosen Availability Zone. Example: us-east-2a . Defaults to None.
        allow_version_upgrade(bool, optional): If true, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.  Default: true . Defaults to None.
        cluster_subnet_group_name(str, optional): The name of the subnet group where you want to cluster restored. A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name where you want the cluster restored. Defaults to None.
        publicly_accessible(bool, optional): If true, the cluster can be accessed from a public network. . Defaults to None.
        owner_account(str, optional): The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot. Defaults to None.
        hsm_client_certificate_identifier(str, optional): Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM. Defaults to None.
        hsm_configuration_identifier(str, optional): Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM. Defaults to None.
        elastic_ip(str, optional): The elastic IP (EIP) address for the cluster. Defaults to None.
        cluster_parameter_group_name(str, optional): The name of the parameter group to be associated with this cluster. Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to Working with Amazon Redshift Parameter Groups. Constraints:   Must be 1 to 255 alphanumeric characters or hyphens.   First character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.  . Defaults to None.
        cluster_security_groups(List, optional): A list of security groups to be associated with this cluster. Default: The default cluster security group for Amazon Redshift. Cluster security groups only apply to clusters outside of VPCs. Defaults to None.
        vpc_security_group_ids(List, optional): A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster. Default: The default VPC security group is associated with the cluster. VPC security groups only apply to clusters in VPCs. Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range (in UTC) during which automated cluster maintenance can occur.  Format: ddd:hh24:mi-ddd:hh24:mi   Default: The value selected for the cluster from which the snapshot was taken. For more information about the time blocks for each region, see Maintenance Windows in Amazon Redshift Cluster Management Guide.  Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun Constraints: Minimum 30-minute window. Defaults to None.
        automated_snapshot_retention_period(int, optional): The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with CreateClusterSnapshot.  You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days. Default: The value selected for the cluster from which the snapshot was taken. Constraints: Must be a value from 0 to 35. Defaults to None.
        manual_snapshot_retention_period(int, optional): The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots. The value must be either -1 or an integer between 1 and 3,653. Defaults to None.
        kms_key_id(str, optional): The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster that you restore from a shared snapshot. Defaults to None.
        node_type(str, optional): The node type that the restored cluster will be provisioned with. Default: The node type of the cluster from which the snapshot was taken. You can modify this if you are using any DS node type. In that case, you can choose to restore into another DS node type of the same size. For example, you can restore ds1.8xlarge into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you have a DC instance type, you must restore into that same instance type and size. In other words, you can only restore a dc1.large instance type into another dc1.large instance type or dc2.large instance type. You can't restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge cluster, then resize to a dc2.8large cluster. For more information about node types, see  About Clusters and Nodes in the Amazon Redshift Cluster Management Guide. . Defaults to None.
        enhanced_vpc_routing(bool, optional): An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see Enhanced VPC Routing in the Amazon Redshift Cluster Management Guide. If this option is true, enhanced VPC routing is enabled.  Default: false. Defaults to None.
        additional_info(str, optional): Reserved. Defaults to None.
        iam_roles(List, optional): A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. You can supply up to 10 IAM roles in a single request. A cluster can have up to 10 IAM roles associated at any time. Defaults to None.
        maintenance_track_name(str, optional): The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the MaintenanceTrack value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks. Defaults to None.
        snapshot_schedule_identifier(str, optional): A unique identifier for the snapshot schedule. Defaults to None.
        number_of_nodes(int, optional): The number of nodes specified when provisioning the restored cluster. Defaults to None.
        availability_zone_relocation(bool, optional): The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is restored. Defaults to None.
        aqua_configuration_status(str, optional): The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.   enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.   disabled - Don't use AQUA.    auto - Amazon Redshift determines whether to use AQUA.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.from_cluster_snapshot.restore(
                ctx, cluster_identifier=value, snapshot_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.from_cluster_snapshot.restore cluster_identifier=value, snapshot_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="restore_from_cluster_snapshot",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "SnapshotIdentifier": snapshot_identifier,
            "SnapshotClusterIdentifier": snapshot_cluster_identifier,
            "Port": port,
            "AvailabilityZone": availability_zone,
            "AllowVersionUpgrade": allow_version_upgrade,
            "ClusterSubnetGroupName": cluster_subnet_group_name,
            "PubliclyAccessible": publicly_accessible,
            "OwnerAccount": owner_account,
            "HsmClientCertificateIdentifier": hsm_client_certificate_identifier,
            "HsmConfigurationIdentifier": hsm_configuration_identifier,
            "ElasticIp": elastic_ip,
            "ClusterParameterGroupName": cluster_parameter_group_name,
            "ClusterSecurityGroups": cluster_security_groups,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "AutomatedSnapshotRetentionPeriod": automated_snapshot_retention_period,
            "ManualSnapshotRetentionPeriod": manual_snapshot_retention_period,
            "KmsKeyId": kms_key_id,
            "NodeType": node_type,
            "EnhancedVpcRouting": enhanced_vpc_routing,
            "AdditionalInfo": additional_info,
            "IamRoles": iam_roles,
            "MaintenanceTrackName": maintenance_track_name,
            "SnapshotScheduleIdentifier": snapshot_schedule_identifier,
            "NumberOfNodes": number_of_nodes,
            "AvailabilityZoneRelocation": availability_zone_relocation,
            "AquaConfigurationStatus": aqua_configuration_status,
        },
    )
