"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    subscription_name: str,
    sns_topic_arn: str,
    source_type: str = None,
    source_ids: List = None,
    event_categories: List = None,
    severity: str = None,
    enabled: bool = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console. You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities. Notifications will be sent for all events you want that match those criteria. For example, you can specify source type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity = ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup categories for the specified clusters. If you specify both the source type and source IDs, such as source type = cluster and source identifier = my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source type but do not specify a source identifier, you will receive notice of the events for the objects of that type in your Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services account. You must specify a source type if you specify a source ID.

    Args:
        subscription_name(str): The name of the event subscription to be created. Constraints:   Cannot be null, empty, or blank.   Must contain from 1 to 255 alphanumeric characters or hyphens.   First character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.  .
        sns_topic_arn(str): The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to it.
        source_type(str, optional): The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs. Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action. Defaults to None.
        source_ids(List, optional): A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified. Example: my-cluster-1, my-cluster-2 Example: my-snapshot-20131010. Defaults to None.
        event_categories(List, optional): Specifies the Amazon Redshift event categories to be published by the event notification subscription. Values: configuration, management, monitoring, security, pending. Defaults to None.
        severity(str, optional): Specifies the Amazon Redshift event severity to be published by the event notification subscription. Values: ERROR, INFO. Defaults to None.
        enabled(bool, optional): A boolean value; set to true to activate the subscription, and set to false to create the subscription but not activate it. . Defaults to None.
        tags(List, optional): A list of tag instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.event.subscription.create(
                ctx, subscription_name=value, sns_topic_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.event.subscription.create subscription_name=value, sns_topic_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_event_subscription",
        op_kwargs={
            "SubscriptionName": subscription_name,
            "SnsTopicArn": sns_topic_arn,
            "SourceType": source_type,
            "SourceIds": source_ids,
            "EventCategories": event_categories,
            "Severity": severity,
            "Enabled": enabled,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, subscription_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an Amazon Redshift event notification subscription.

    Args:
        subscription_name(str): The name of the Amazon Redshift event notification subscription to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.event.subscription.delete(ctx, subscription_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.event.subscription.delete subscription_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_event_subscription",
        op_kwargs={"SubscriptionName": subscription_name},
    )


async def describe_all(
    hub,
    ctx,
    subscription_name: str = None,
    max_records: int = None,
    marker: str = None,
    tag_keys: List = None,
    tag_values: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you specify a subscription name, lists the description for that subscription. If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification subscriptions that match any combination of the specified keys and values. For example, if you have owner and environment for tag keys, and admin and test for tag values, all subscriptions that have any combination of those values are returned. If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they have tag keys or values associated with them.

    Args:
        subscription_name(str, optional): The name of the Amazon Redshift event notification subscription to be described. Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.  Default: 100  Constraints: minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeEventSubscriptions request exceed the value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.
        tag_keys(List, optional): A tag key or keys for which you want to return all matching event notification subscriptions that are associated with the specified key or keys. For example, suppose that you have subscriptions that are tagged with keys called owner and environment. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag keys associated with them. Defaults to None.
        tag_values(List, optional): A tag value or values for which you want to return all matching event notification subscriptions that are associated with the specified tag value or values. For example, suppose that you have subscriptions that are tagged with values called admin and test. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag values associated with them. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.event.subscription.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.event.subscription.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_event_subscriptions",
        op_kwargs={
            "SubscriptionName": subscription_name,
            "MaxRecords": max_records,
            "Marker": marker,
            "TagKeys": tag_keys,
            "TagValues": tag_values,
        },
    )


async def modify(
    hub,
    ctx,
    subscription_name: str,
    sns_topic_arn: str = None,
    source_type: str = None,
    source_ids: List = None,
    event_categories: List = None,
    severity: str = None,
    enabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies an existing Amazon Redshift event notification subscription.

    Args:
        subscription_name(str): The name of the modified Amazon Redshift event notification subscription.
        sns_topic_arn(str, optional): The Amazon Resource Name (ARN) of the SNS topic to be used by the event notification subscription. Defaults to None.
        source_type(str, optional): The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs. Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action. Defaults to None.
        source_ids(List, optional): A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified. Example: my-cluster-1, my-cluster-2 Example: my-snapshot-20131010. Defaults to None.
        event_categories(List, optional): Specifies the Amazon Redshift event categories to be published by the event notification subscription. Values: configuration, management, monitoring, security, pending. Defaults to None.
        severity(str, optional): Specifies the Amazon Redshift event severity to be published by the event notification subscription. Values: ERROR, INFO. Defaults to None.
        enabled(bool, optional): A Boolean value indicating if the subscription is enabled. true indicates the subscription is enabled . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.event.subscription.modify(ctx, subscription_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.event.subscription.modify subscription_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_event_subscription",
        op_kwargs={
            "SubscriptionName": subscription_name,
            "SnsTopicArn": sns_topic_arn,
            "SourceType": source_type,
            "SourceIds": source_ids,
            "EventCategories": event_categories,
            "Severity": severity,
            "Enabled": enabled,
        },
    )
