"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    cluster_identifier: str = None,
    account: str = None,
    grantee: bool = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes an endpoint authorization.

    Args:
        cluster_identifier(str, optional): The cluster identifier of the cluster to access. Defaults to None.
        account(str, optional): The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee. If Grantee parameter is true, then the Account value is of the grantor. Defaults to None.
        grantee(bool, optional): Indicates whether to check authorization from a grantor or grantee point of view. If true, Amazon Redshift returns endpoint authorizations that you've been granted. If false (default), checks authorization from a grantor point of view. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a Marker is included in the response so that the remaining results can be retrieved. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous DescribeEndpointAuthorization request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the MaxRecords parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.endpoint.authorization.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.endpoint.authorization.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_endpoint_authorization",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "Account": account,
            "Grantee": grantee,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
