"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def authorize(
    hub, ctx, account: str, cluster_identifier: str = None, vpc_ids: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Grants access to a cluster.

    Args:
        cluster_identifier(str, optional): The cluster identifier of the cluster to grant access to. Defaults to None.
        account(str): The Amazon Web Services account ID to grant access to.
        vpc_ids(List, optional): The virtual private cloud (VPC) identifiers to grant access to. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.endpoint.access.authorize(ctx, account=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.endpoint.access.authorize account=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="authorize_endpoint_access",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "Account": account,
            "VpcIds": vpc_ids,
        },
    )


async def create(
    hub,
    ctx,
    endpoint_name: str,
    subnet_group_name: str,
    cluster_identifier: str = None,
    resource_owner: str = None,
    vpc_security_group_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Redshift-managed VPC endpoint.

    Args:
        cluster_identifier(str, optional): The cluster identifier of the cluster to access. Defaults to None.
        resource_owner(str, optional): The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account. Defaults to None.
        endpoint_name(str): The Redshift-managed VPC endpoint name. An endpoint name must contain 1-30 characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must be a letter. The name can't contain two consecutive hyphens or end with a hyphen.
        subnet_group_name(str): The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
        vpc_security_group_ids(List, optional): The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.endpoint.access.create(
                ctx, endpoint_name=value, subnet_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.endpoint.access.create endpoint_name=value, subnet_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_endpoint_access",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "ResourceOwner": resource_owner,
            "EndpointName": endpoint_name,
            "SubnetGroupName": subnet_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
        },
    )


async def delete(hub, ctx, endpoint_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a Redshift-managed VPC endpoint.

    Args:
        endpoint_name(str): The Redshift-managed VPC endpoint to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.endpoint.access.delete(ctx, endpoint_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.endpoint.access.delete endpoint_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_endpoint_access",
        op_kwargs={"EndpointName": endpoint_name},
    )


async def describe(
    hub,
    ctx,
    cluster_identifier: str = None,
    resource_owner: str = None,
    endpoint_name: str = None,
    vpc_id: str = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes a Redshift-managed VPC endpoint.

    Args:
        cluster_identifier(str, optional): The cluster identifier associated with the described endpoint. Defaults to None.
        resource_owner(str, optional): The Amazon Web Services account ID of the owner of the cluster. Defaults to None.
        endpoint_name(str, optional): The name of the endpoint to be described. Defaults to None.
        vpc_id(str, optional): The virtual private cloud (VPC) identifier with access to the cluster. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a Marker is included in the response so that the remaining results can be retrieved. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous DescribeEndpointAccess request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the MaxRecords parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.endpoint.access.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.endpoint.access.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_endpoint_access",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "ResourceOwner": resource_owner,
            "EndpointName": endpoint_name,
            "VpcId": vpc_id,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(
    hub, ctx, endpoint_name: str, vpc_security_group_ids: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a Redshift-managed VPC endpoint.

    Args:
        endpoint_name(str): The endpoint to be modified.
        vpc_security_group_ids(List, optional): The complete list of VPC security groups associated with the endpoint after the endpoint is modified. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.endpoint.access.modify(ctx, endpoint_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.endpoint.access.modify endpoint_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_endpoint_access",
        op_kwargs={
            "EndpointName": endpoint_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
        },
    )


async def revoke(
    hub,
    ctx,
    cluster_identifier: str = None,
    account: str = None,
    vpc_ids: List = None,
    force: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Revokes access to a cluster.

    Args:
        cluster_identifier(str, optional): The cluster to revoke access from. Defaults to None.
        account(str, optional): The Amazon Web Services account ID whose access is to be revoked. Defaults to None.
        vpc_ids(List, optional): The virtual private cloud (VPC) identifiers for which access is to be revoked. Defaults to None.
        force(bool, optional): Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.endpoint.access.revoke(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.endpoint.access.revoke
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="revoke_endpoint_access",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "Account": account,
            "VpcIds": vpc_ids,
            "Force": force,
        },
    )
