"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def rotate(hub, ctx, cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Rotates the encryption keys for a cluster.

    Args:
        cluster_identifier(str): The unique identifier of the cluster that you want to rotate the encryption keys for. Constraints: Must be the name of valid cluster that has encryption enabled.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.encryption_key.rotate(ctx, cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.encryption_key.rotate cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="rotate_encryption_key",
        op_kwargs={"ClusterIdentifier": cluster_identifier},
    )
