"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, identifiers: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a set of cluster snapshots.

    Args:
        identifiers(List): A list of identifiers for the snapshots that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.delete_cluster_snapshot.batch(ctx, identifiers=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.delete_cluster_snapshot.batch identifiers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="batch_delete_cluster_snapshots",
        op_kwargs={"Identifiers": identifiers},
    )
