"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, parameter_group_family: str, max_records: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of parameter settings for the specified parameter group family.  For more information about parameters and parameter groups, go to Amazon Redshift Parameter Groups in the Amazon Redshift Cluster Management Guide.

    Args:
        parameter_group_family(str): The name of the cluster parameter group family.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.  Default: 100  Constraints: minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeDefaultClusterParameters request exceed the value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.default_cluster_parameter.describe_all(
                ctx, parameter_group_family=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.default_cluster_parameter.describe_all parameter_group_family=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_default_cluster_parameters",
        op_kwargs={
            "ParameterGroupFamily": parameter_group_family,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
