"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def authorize(hub, ctx, data_share_arn: str, consumer_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts. To authorize a datashare for a data consumer, the producer account must have the correct access privileges.

    Args:
        data_share_arn(str): The Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.
        consumer_identifier(str): The identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS account ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.data_share.init.authorize(
                ctx, data_share_arn=value, consumer_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.data_share.init.authorize data_share_arn=value, consumer_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="authorize_data_share",
        op_kwargs={
            "DataShareArn": data_share_arn,
            "ConsumerIdentifier": consumer_identifier,
        },
    )


async def deauthorize(hub, ctx, data_share_arn: str, consumer_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    From the producer account, removes authorization from the specified datashare.

    Args:
        data_share_arn(str): The Amazon Resource Name (ARN) of the datashare to remove authorization from.
        consumer_identifier(str): The identifier of the data consumer that is to have authorization removed from the datashare. This identifier is an AWS account ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.data_share.init.deauthorize(
                ctx, data_share_arn=value, consumer_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.data_share.init.deauthorize data_share_arn=value, consumer_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="deauthorize_data_share",
        op_kwargs={
            "DataShareArn": data_share_arn,
            "ConsumerIdentifier": consumer_identifier,
        },
    )


async def describe_all(
    hub, ctx, data_share_arn: str = None, max_records: int = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Shows the status of any inbound or outbound datashares available in the specified account.

    Args:
        data_share_arn(str, optional): The identifier of the datashare to describe details of. Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. . Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeDataShares request exceed the value specified in MaxRecords, AWS returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.data_share.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.data_share.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_data_shares",
        op_kwargs={
            "DataShareArn": data_share_arn,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def reject(hub, ctx, data_share_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    From the consumer account, rejects the specified datashare.

    Args:
        data_share_arn(str): The Amazon Resource Name (ARN) of the datashare to reject.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.data_share.init.reject(ctx, data_share_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.data_share.init.reject data_share_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="reject_data_share",
        op_kwargs={"DataShareArn": data_share_arn},
    )
