"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    consumer_arn: str = None,
    status: str = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of datashares where the account identifier being called is a consumer account identifier.

    Args:
        consumer_arn(str, optional): The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares. Defaults to None.
        status(str, optional): An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon Redshift returns the list of datashares that have the specified status. Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. . Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeDataSharesForConsumer request exceed the value specified in MaxRecords, AWS returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.data_share.for_.consumer.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.data_share.for_.consumer.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_data_shares_for_consumer",
        op_kwargs={
            "ConsumerArn": consumer_arn,
            "Status": status,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
