"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    data_share_arn: str,
    associate_entire_account: bool = None,
    consumer_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.

    Args:
        data_share_arn(str): The Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.
        associate_entire_account(bool, optional): A value that specifies whether the datashare is associated with the entire account. Defaults to None.
        consumer_arn(str, optional): The Amazon Resource Name (ARN) of the consumer that is associated with the datashare. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.data_share.consumer.associate(
                ctx, data_share_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.data_share.consumer.associate data_share_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="associate_data_share_consumer",
        op_kwargs={
            "DataShareArn": data_share_arn,
            "AssociateEntireAccount": associate_entire_account,
            "ConsumerArn": consumer_arn,
        },
    )


async def disassociate(
    hub,
    ctx,
    data_share_arn: str,
    disassociate_entire_account: bool = None,
    consumer_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    From a consumer account, remove association for the specified datashare.

    Args:
        data_share_arn(str): The Amazon Resource Name (ARN) of the datashare to remove association for. .
        disassociate_entire_account(bool, optional): A value that specifies whether association for the datashare is removed from the entire account. Defaults to None.
        consumer_arn(str, optional): The Amazon Resource Name (ARN) of the consumer that association for the datashare is removed from. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.data_share.consumer.disassociate(
                ctx, data_share_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.data_share.consumer.disassociate data_share_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="disassociate_data_share_consumer",
        op_kwargs={
            "DataShareArn": data_share_arn,
            "DisassociateEntireAccount": disassociate_entire_account,
            "ConsumerArn": consumer_arn,
        },
    )
