"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    cluster_subnet_group_name: str,
    description: str,
    subnet_ids: List,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.  For information about subnet groups, go to Amazon Redshift Cluster Subnet Groups in the Amazon Redshift Cluster Management Guide.

    Args:
        cluster_subnet_group_name(str): The name for the subnet group. Amazon Redshift stores the value as a lowercase string. Constraints:   Must contain no more than 255 alphanumeric characters or hyphens.   Must not be "Default".   Must be unique for all subnet groups that are created by your Amazon Web Services account.   Example: examplesubnetgroup .
        description(str): A description for the subnet group.
        subnet_ids(List): An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.
        tags(List, optional): A list of tag instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.subnet_group.create(
                ctx, cluster_subnet_group_name=value, description=value, subnet_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.subnet_group.create cluster_subnet_group_name=value, description=value, subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_cluster_subnet_group",
        op_kwargs={
            "ClusterSubnetGroupName": cluster_subnet_group_name,
            "Description": description,
            "SubnetIds": subnet_ids,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, cluster_subnet_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified cluster subnet group.

    Args:
        cluster_subnet_group_name(str): The name of the cluster subnet group name to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.subnet_group.delete(
                ctx, cluster_subnet_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.subnet_group.delete cluster_subnet_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_cluster_subnet_group",
        op_kwargs={"ClusterSubnetGroupName": cluster_subnet_group_name},
    )


async def describe_all(
    hub,
    ctx,
    cluster_subnet_group_name: str = None,
    max_records: int = None,
    marker: str = None,
    tag_keys: List = None,
    tag_values: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web Services account. If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that match any combination of the specified keys and values. For example, if you have owner and environment for tag keys, and admin and test for tag values, all subnet groups that have any combination of those values are returned. If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they have tag keys or values associated with them.

    Args:
        cluster_subnet_group_name(str, optional): The name of the cluster subnet group for which information is requested. Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.  Default: 100  Constraints: minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeClusterSubnetGroups request exceed the value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.
        tag_keys(List, optional): A tag key or keys for which you want to return all matching cluster subnet groups that are associated with the specified key or keys. For example, suppose that you have subnet groups that are tagged with keys called owner and environment. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag keys associated with them. Defaults to None.
        tag_values(List, optional): A tag value or values for which you want to return all matching cluster subnet groups that are associated with the specified tag value or values. For example, suppose that you have subnet groups that are tagged with values called admin and test. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag values associated with them. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.subnet_group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.subnet_group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_cluster_subnet_groups",
        op_kwargs={
            "ClusterSubnetGroupName": cluster_subnet_group_name,
            "MaxRecords": max_records,
            "Marker": marker,
            "TagKeys": tag_keys,
            "TagValues": tag_values,
        },
    )


async def modify(
    hub, ctx, cluster_subnet_group_name: str, subnet_ids: List, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing list of subnets with the new list of subnets.

    Args:
        cluster_subnet_group_name(str): The name of the subnet group to be modified.
        description(str, optional): A text description of the subnet group to be modified. Defaults to None.
        subnet_ids(List): An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.subnet_group.modify(
                ctx, cluster_subnet_group_name=value, subnet_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.subnet_group.modify cluster_subnet_group_name=value, subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_cluster_subnet_group",
        op_kwargs={
            "ClusterSubnetGroupName": cluster_subnet_group_name,
            "Description": description,
            "SubnetIds": subnet_ids,
        },
    )
