"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def modify(
    hub,
    ctx,
    cluster_identifier: str,
    schedule_identifier: str = None,
    disassociate_schedule: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Modifies a snapshot schedule for a cluster.

    Args:
        cluster_identifier(str): A unique identifier for the cluster whose snapshot schedule you want to modify. .
        schedule_identifier(str, optional): A unique alphanumeric identifier for the schedule that you want to associate with the cluster. Defaults to None.
        disassociate_schedule(bool, optional): A boolean to indicate whether to remove the assoiciation between the cluster and the schedule. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.snapshot.schedule.modify(
                ctx, cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.snapshot.schedule.modify cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_cluster_snapshot_schedule",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "ScheduleIdentifier": schedule_identifier,
            "DisassociateSchedule": disassociate_schedule,
        },
    )
