"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub,
    ctx,
    source_snapshot_identifier: str,
    target_snapshot_identifier: str,
    source_snapshot_cluster_identifier: str = None,
    manual_snapshot_retention_period: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated snapshot and it must be in the available state. When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained until you delete them.  For more information about working with snapshots, go to Amazon Redshift Snapshots in the Amazon Redshift Cluster Management Guide.

    Args:
        source_snapshot_identifier(str): The identifier for the source snapshot. Constraints:   Must be the identifier for a valid automated snapshot whose state is available.  .
        source_snapshot_cluster_identifier(str, optional): The identifier of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name. Constraints:   Must be the identifier for a valid cluster.  . Defaults to None.
        target_snapshot_identifier(str): The identifier given to the new manual snapshot. Constraints:   Cannot be null, empty, or blank.   Must contain from 1 to 255 alphanumeric characters or hyphens.   First character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.   Must be unique for the Amazon Web Services account that is making the request.  .
        manual_snapshot_retention_period(int, optional): The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.  The value must be either -1 or an integer between 1 and 3,653. The default value is -1. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.snapshot.init.copy(
                ctx, source_snapshot_identifier=value, target_snapshot_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.snapshot.init.copy source_snapshot_identifier=value, target_snapshot_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="copy_cluster_snapshot",
        op_kwargs={
            "SourceSnapshotIdentifier": source_snapshot_identifier,
            "SourceSnapshotClusterIdentifier": source_snapshot_cluster_identifier,
            "TargetSnapshotIdentifier": target_snapshot_identifier,
            "ManualSnapshotRetentionPeriod": manual_snapshot_retention_period,
        },
    )


async def create(
    hub,
    ctx,
    snapshot_identifier: str,
    cluster_identifier: str,
    manual_snapshot_retention_period: int = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a manual snapshot of the specified cluster. The cluster must be in the available state.   For more information about working with snapshots, go to Amazon Redshift Snapshots in the Amazon Redshift Cluster Management Guide.

    Args:
        snapshot_identifier(str): A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account. Constraints:   Cannot be null, empty, or blank   Must contain from 1 to 255 alphanumeric characters or hyphens   First character must be a letter   Cannot end with a hyphen or contain two consecutive hyphens   Example: my-snapshot-id .
        cluster_identifier(str): The cluster identifier for which you want a snapshot.
        manual_snapshot_retention_period(int, optional): The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.  The value must be either -1 or an integer between 1 and 3,653. The default value is -1. Defaults to None.
        tags(List, optional): A list of tag instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.snapshot.init.create(
                ctx, snapshot_identifier=value, cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.snapshot.init.create snapshot_identifier=value, cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_cluster_snapshot",
        op_kwargs={
            "SnapshotIdentifier": snapshot_identifier,
            "ClusterIdentifier": cluster_identifier,
            "ManualSnapshotRetentionPeriod": manual_snapshot_retention_period,
            "Tags": tags,
        },
    )


async def delete(
    hub, ctx, snapshot_identifier: str, snapshot_cluster_identifier: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified manual snapshot. The snapshot must be in the available state, with no other users authorized to access the snapshot.  Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can delete the snapshot.

    Args:
        snapshot_identifier(str): The unique identifier of the manual snapshot to be deleted. Constraints: Must be the name of an existing snapshot that is in the available, failed, or cancelled state.
        snapshot_cluster_identifier(str, optional): The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name. Constraints: Must be the name of valid cluster. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.snapshot.init.delete(
                ctx, snapshot_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.snapshot.init.delete snapshot_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_cluster_snapshot",
        op_kwargs={
            "SnapshotIdentifier": snapshot_identifier,
            "SnapshotClusterIdentifier": snapshot_cluster_identifier,
        },
    )


async def describe_all(
    hub,
    ctx,
    cluster_identifier: str = None,
    snapshot_identifier: str = None,
    snapshot_type: str = None,
    start_time: str = None,
    end_time: str = None,
    max_records: int = None,
    marker: str = None,
    owner_account: str = None,
    tag_keys: List = None,
    tag_values: List = None,
    cluster_exists: bool = None,
    sorting_entities: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services account. No information is returned for snapshots owned by inactive Amazon Web Services accounts. If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match any combination of the specified keys and values. For example, if you have owner and environment for tag keys, and admin and test for tag values, all snapshots that have any combination of those values are returned. Only snapshots that you own are returned in the response; shared snapshots are not returned with the tag key and tag value request parameters. If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have tag keys or values associated with them.

    Args:
        cluster_identifier(str, optional): The identifier of the cluster which generated the requested snapshots. Defaults to None.
        snapshot_identifier(str, optional): The snapshot identifier of the snapshot about which to return information. Defaults to None.
        snapshot_type(str, optional): The type of snapshots for which you are requesting information. By default, snapshots of all types are returned. Valid Values: automated | manual . Defaults to None.
        start_time(str, optional): A value that requests only snapshots created at or after the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia page.  Example: 2012-07-16T18:00:00Z . Defaults to None.
        end_time(str, optional): A time value that requests only snapshots created at or before the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia page.  Example: 2012-07-16T18:00:00Z . Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.  Default: 100  Constraints: minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeClusterSnapshots request exceed the value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.
        owner_account(str, optional): The Amazon Web Services account used to create or copy the snapshot. Use this field to filter the results to snapshots owned by a particular account. To describe snapshots you own, either specify your Amazon Web Services account, or do not specify the parameter. Defaults to None.
        tag_keys(List, optional): A tag key or keys for which you want to return all matching cluster snapshots that are associated with the specified key or keys. For example, suppose that you have snapshots that are tagged with keys called owner and environment. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag keys associated with them. Defaults to None.
        tag_values(List, optional): A tag value or values for which you want to return all matching cluster snapshots that are associated with the specified tag value or values. For example, suppose that you have snapshots that are tagged with values called admin and test. If you specify both of these tag values in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag values associated with them. Defaults to None.
        cluster_exists(bool, optional): A value that indicates whether to return snapshots only for an existing cluster. You can perform table-level restore only by using a snapshot of an existing cluster, that is, a cluster that has not been deleted. Values for this parameter work as follows:    If ClusterExists is set to true, ClusterIdentifier is required.   If ClusterExists is set to false and ClusterIdentifier isn't specified, all snapshots associated with deleted clusters (orphaned snapshots) are returned.    If ClusterExists is set to false and ClusterIdentifier is specified for a deleted cluster, snapshots associated with that cluster are returned.   If ClusterExists is set to false and ClusterIdentifier is specified for an existing cluster, no snapshots are returned.   . Defaults to None.
        sorting_entities(List, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.snapshot.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.snapshot.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_cluster_snapshots",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "SnapshotIdentifier": snapshot_identifier,
            "SnapshotType": snapshot_type,
            "StartTime": start_time,
            "EndTime": end_time,
            "MaxRecords": max_records,
            "Marker": marker,
            "OwnerAccount": owner_account,
            "TagKeys": tag_keys,
            "TagValues": tag_values,
            "ClusterExists": cluster_exists,
            "SortingEntities": sorting_entities,
        },
    )


async def modify(
    hub,
    ctx,
    snapshot_identifier: str,
    manual_snapshot_retention_period: int = None,
    force: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the settings for a snapshot. This exanmple modifies the manual retention period setting for a cluster snapshot.

    Args:
        snapshot_identifier(str): The identifier of the snapshot whose setting you want to modify.
        manual_snapshot_retention_period(int, optional): The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. If the manual snapshot falls outside of the new retention period, you can specify the force option to immediately delete the snapshot. The value must be either -1 or an integer between 1 and 3,653. Defaults to None.
        force(bool, optional): A Boolean option to override an exception if the retention period has already passed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.snapshot.init.modify(
                ctx, snapshot_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.snapshot.init.modify snapshot_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_cluster_snapshot",
        op_kwargs={
            "SnapshotIdentifier": snapshot_identifier,
            "ManualSnapshotRetentionPeriod": manual_snapshot_retention_period,
            "Force": force,
        },
    )
