"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def authorize(
    hub,
    ctx,
    cluster_security_group_name: str,
    cidrip: str = None,
    ec2_security_group_name: str = None,
    ec2_security_group_owner_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as many as 20 ingress rules to an Amazon Redshift security group. If you authorize access to an Amazon EC2 security group, specify EC2SecurityGroupName and EC2SecurityGroupOwnerId. The Amazon EC2 security group and Amazon Redshift cluster must be in the same Amazon Web Services Region.  If you authorize access to a CIDR/IP address range, specify CIDRIP. For an overview of CIDR blocks, see the Wikipedia article on Classless Inter-Domain Routing.  You must also associate the security group with a cluster so that clients running on these IP addresses or the EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to Working with Security Groups in the Amazon Redshift Cluster Management Guide.

    Args:
        cluster_security_group_name(str): The name of the security group to which the ingress rule is added.
        cidrip(str, optional): The IP range to be added the Amazon Redshift security group. Defaults to None.
        ec2_security_group_name(str, optional): The EC2 security group to be added the Amazon Redshift security group. Defaults to None.
        ec2_security_group_owner_id(str, optional): The Amazon Web Services account number of the owner of the security group specified by the EC2SecurityGroupName parameter. The Amazon Web Services Access Key ID is not an acceptable value.  Example: 111122223333 . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.security_group.ingress.authorize(
                ctx, cluster_security_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.security_group.ingress.authorize cluster_security_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="authorize_cluster_security_group_ingress",
        op_kwargs={
            "ClusterSecurityGroupName": cluster_security_group_name,
            "CIDRIP": cidrip,
            "EC2SecurityGroupName": ec2_security_group_name,
            "EC2SecurityGroupOwnerId": ec2_security_group_owner_id,
        },
    )


async def revoke(
    hub,
    ctx,
    cluster_security_group_name: str,
    cidrip: str = None,
    ec2_security_group_name: str = None,
    ec2_security_group_owner_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Revokes an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2 security group. To add an ingress rule, see AuthorizeClusterSecurityGroupIngress. For information about managing security groups, go to Amazon Redshift Cluster Security Groups in the Amazon Redshift Cluster Management Guide.

    Args:
        cluster_security_group_name(str): The name of the security Group from which to revoke the ingress rule.
        cidrip(str, optional): The IP range for which to revoke access. This range must be a valid Classless Inter-Domain Routing (CIDR) block of IP addresses. If CIDRIP is specified, EC2SecurityGroupName and EC2SecurityGroupOwnerId cannot be provided. . Defaults to None.
        ec2_security_group_name(str, optional): The name of the EC2 Security Group whose access is to be revoked. If EC2SecurityGroupName is specified, EC2SecurityGroupOwnerId must also be provided and CIDRIP cannot be provided. . Defaults to None.
        ec2_security_group_owner_id(str, optional): The Amazon Web Services account number of the owner of the security group specified in the EC2SecurityGroupName parameter. The Amazon Web Services access key ID is not an acceptable value. If EC2SecurityGroupOwnerId is specified, EC2SecurityGroupName must also be provided. and CIDRIP cannot be provided.  Example: 111122223333 . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.security_group.ingress.revoke(
                ctx, cluster_security_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.security_group.ingress.revoke cluster_security_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="revoke_cluster_security_group_ingress",
        op_kwargs={
            "ClusterSecurityGroupName": cluster_security_group_name,
            "CIDRIP": cidrip,
            "EC2SecurityGroupName": ec2_security_group_name,
            "EC2SecurityGroupOwnerId": ec2_security_group_owner_id,
        },
    )
